/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.peak;

import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.msd.swt.ui.components.AbstractPeakLineSeriesUI;
import org.eclipse.chemclipse.msd.swt.ui.converter.SeriesConverterMSD;
import org.eclipse.chemclipse.swt.ui.components.peaks.IIncludeBackground;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public abstract class AbstractViewPeakUI
extends AbstractPeakLineSeriesUI
implements IIncludeBackground {
    private boolean includeBackground = false;

    public AbstractViewPeakUI(Composite parent, int style, IAxisTitles axisTitles) {
        super(parent, style, axisTitles);
    }

    public boolean isIncludeBackground() {
        return this.includeBackground;
    }

    public void setIncludeBackground(boolean includeBackground) {
        this.includeBackground = includeBackground;
    }

    public void setViewSeries() {
        Sign sign = Sign.POSITIVE;
        ISeries series = SeriesConverter.convertPeak((IPeak)this.peak, (boolean)this.includeBackground, (Sign)sign);
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.RED);
        series = SeriesConverterMSD.convertIncreasingInflectionPoints(this.peak, this.includeBackground, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.BLACK);
        series = SeriesConverterMSD.convertDecreasingInflectionPoints(this.peak, this.includeBackground, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.BLACK);
        series = SeriesConverterMSD.convertPeakPerpendicular(this.peak, this.includeBackground, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.DARK_RED);
        series = SeriesConverterMSD.convertPeakWidthByInflectionPoints(this.peak, this.includeBackground, 0.5f, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.DARK_RED);
        series = SeriesConverterMSD.convertPeakWidthByInflectionPoints(this.peak, this.includeBackground, 0.0f, sign);
        this.addSeries(series);
        lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(false);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.DARK_RED);
        if (this.includeBackground) {
            series = SeriesConverter.convertPeakBackground((IPeak)this.peak, (Sign)sign);
            this.addSeries(series);
            lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            lineSeries.setXSeries(series.getXSeries());
            lineSeries.setYSeries(series.getYSeries());
            lineSeries.enableArea(true);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeries.setLineColor(Colors.BLACK);
        }
    }
}

