/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.internal.provider;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.chemclipse.model.comparator.SortOrder;
import org.eclipse.chemclipse.model.comparator.TargetExtendedComparator;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.swt.graphics.Image;

public class MassSpectrumListLabelProvider
extends AbstractChemClipseLabelProvider {
    private TargetExtendedComparator targetExtendedComparator = new TargetExtendedComparator(SortOrder.DESC);

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof IRegularLibraryMassSpectrum) {
            IRegularLibraryMassSpectrum libraryMassSpectrum = (IRegularLibraryMassSpectrum)element;
            ILibraryInformation libraryInformation = libraryMassSpectrum.getLibraryInformation();
            return this.getText((IScanMSD)libraryMassSpectrum, libraryInformation, columnIndex);
        }
        if (element instanceof IScanMSD) {
            IScanMSD massSpectrum = (IScanMSD)element;
            ILibraryInformation libraryInformation = this.getLibraryInformation(massSpectrum.getTargets());
            if (massSpectrum.getOptimizedMassSpectrum() != null) {
                massSpectrum = massSpectrum.getOptimizedMassSpectrum();
            }
            return this.getText(massSpectrum, libraryInformation, columnIndex);
        }
        return "n.a.";
    }

    public Image getImage(Object element) {
        Image image = ApplicationImageFactory.getInstance().getImage("massSpectrum.gif", "16x16");
        return image;
    }

    private String getText(IScanMSD massSpectrum, ILibraryInformation libraryInformation, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        switch (columnIndex) {
            case 0: {
                if (libraryInformation == null) break;
                text = libraryInformation.getName();
                break;
            }
            case 1: {
                if (massSpectrum.getRetentionTime() == 0) {
                    text = "0";
                    break;
                }
                text = decimalFormat.format((double)massSpectrum.getRetentionTime() / 60000.0);
                break;
            }
            case 2: {
                int retentionIndexNoPrecision = (int)massSpectrum.getRetentionIndex();
                if ((float)retentionIndexNoPrecision == massSpectrum.getRetentionIndex()) {
                    text = Integer.toString(retentionIndexNoPrecision);
                    break;
                }
                if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                    text = Integer.toString(retentionIndexNoPrecision);
                    break;
                }
                text = decimalFormat.format(massSpectrum.getRetentionIndex());
                break;
            }
            case 3: {
                int basePeakNoPrecision = (int)massSpectrum.getBasePeak();
                if ((double)basePeakNoPrecision == massSpectrum.getBasePeak()) {
                    text = Integer.toString(basePeakNoPrecision);
                    break;
                }
                text = decimalFormat.format(massSpectrum.getBasePeak());
                break;
            }
            case 4: {
                int basePeakAbundanceNoPrecision = (int)massSpectrum.getBasePeakAbundance();
                if ((float)basePeakAbundanceNoPrecision == massSpectrum.getBasePeakAbundance()) {
                    text = Integer.toString(basePeakAbundanceNoPrecision);
                    break;
                }
                text = decimalFormat.format(massSpectrum.getBasePeakAbundance());
                break;
            }
            case 5: {
                text = Integer.toString(massSpectrum.getNumberOfIons());
                break;
            }
            case 6: {
                if (libraryInformation == null) break;
                text = libraryInformation.getCasNumber();
                break;
            }
            case 7: {
                if (libraryInformation == null) break;
                int molWeightNoPrecision = (int)libraryInformation.getMolWeight();
                if ((double)molWeightNoPrecision == libraryInformation.getMolWeight()) {
                    text = Integer.toString(molWeightNoPrecision);
                    break;
                }
                text = decimalFormat.format(libraryInformation.getMolWeight());
                break;
            }
            case 8: {
                if (libraryInformation == null) break;
                text = libraryInformation.getFormula();
                break;
            }
            case 9: {
                if (libraryInformation == null) break;
                text = libraryInformation.getSmiles();
                break;
            }
            case 10: {
                if (libraryInformation == null) break;
                text = libraryInformation.getInChI();
                break;
            }
            case 11: {
                if (libraryInformation == null) break;
                text = libraryInformation.getReferenceIdentifier();
                break;
            }
            case 12: {
                if (libraryInformation == null) break;
                text = libraryInformation.getComments();
                break;
            }
            default: {
                text = "n.v.";
            }
        }
        return text;
    }

    private ILibraryInformation getLibraryInformation(List<IMassSpectrumTarget> targets) {
        ILibraryInformation libraryInformation = null;
        Collections.sort(targets, this.targetExtendedComparator);
        if (targets.size() >= 1) {
            libraryInformation = targets.get(0).getLibraryInformation();
        }
        return libraryInformation;
    }
}

