/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.chromatogram.IChromatogramTargetMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.ui.provider.TargetsLabelProvider;
import org.eclipse.chemclipse.ux.extension.ui.provider.TargetsTableComparator;
import org.eclipse.chemclipse.ux.extension.ui.provider.TargetsViewEditingSupport;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class AbstractTargetsView {
    private ExtendedTableViewer tableViewer;
    private TargetsTableComparator targetsTableComparator;
    private static final String VERIFIED_MANUALLY = "Verified (manually)";
    private String[] titles = new String[]{"Verified (manually)", "Rating", "Name", "CAS", "Match Factor", "Reverse Factor", "Match Factor Direct", "Reverse Factor Direct", "Probability", "Formula", "SMILES", "InChI", "Mol Weight", "Advise", "Identifier", "Miscellaneous", "Comments", "Database", "Contributor", "Reference ID"};
    private int[] bounds = new int[]{30, 30, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    private IStructuredContentProvider contentProvider;
    private IEventBroker eventBroker;

    public AbstractTargetsView(IStructuredContentProvider contentProvider, IEventBroker eventBroker) {
        this.contentProvider = contentProvider;
        this.eventBroker = eventBroker;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.tableViewer = new ExtendedTableViewer(parent);
        this.tableViewer.createColumns(this.titles, this.bounds);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TargetsLabelProvider());
        this.targetsTableComparator = new TargetsTableComparator();
        this.tableViewer.setComparator((ViewerComparator)this.targetsTableComparator);
        this.setEditingSupport();
        this.tableViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    AbstractTargetsView.this.tableViewer.copyToClipboard(AbstractTargetsView.this.titles);
                } else if (e.keyCode == 127 && e.stateMask == 0) {
                    AbstractTargetsView.this.deleteSelectedTargets();
                } else if (e.keyCode == 105 && e.stateMask == 262144) {
                    AbstractTargetsView.this.manuallyVerifySelectedTargets();
                } else {
                    AbstractTargetsView.this.propagateSelectedTarget();
                }
            }
        });
        this.tableViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                AbstractTargetsView.this.propagateSelectedTarget();
            }
        });
        this.initContextMenu();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    public void update(Object object, boolean forceReload) {
        if (object != null) {
            this.tableViewer.setInput(object);
            this.sortTableInitially(0, -1);
        }
    }

    public void sortTableInitially(int column, int sortOrder) {
        this.targetsTableComparator.setColumn(column);
        this.targetsTableComparator.setDirection(sortOrder);
        this.tableViewer.refresh();
        this.targetsTableComparator.setDirection(1 - sortOrder);
        this.targetsTableComparator.setColumn(column);
    }

    private void initContextMenu() {
        MenuManager menuManager = new MenuManager("#PopUpMenu", "org.eclipse.chemclipse.chromatogram.msd.ui.perspective.internal.views.targetsView.popup");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        AbstractTargetsView.this.tableViewer.copyToClipboard(AbstractTargetsView.this.titles);
                    }
                };
                action.setText("Copy selection to clipboard");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        AbstractTargetsView.this.deleteSelectedTargets();
                    }
                };
                action.setText("Delete selected targets");
                manager.add((IAction)action);
            }
        });
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        super.run();
                        AbstractTargetsView.this.manuallyVerifySelectedTargets();
                    }
                };
                action.setText("Verify selected targets (CTRL+I)");
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu(this.tableViewer.getControl());
        this.tableViewer.getControl().setMenu(menu);
    }

    private void propagateSelectedTarget() {
        TableItem tableItem;
        Object object;
        Table table = this.tableViewer.getTable();
        int index = table.getSelectionIndex();
        if (index >= 0 && (object = (tableItem = table.getItem(index)).getData()) instanceof IIdentificationTarget) {
            IIdentificationTarget target = (IIdentificationTarget)object;
            this.eventBroker.send("identification/target/update", (Object)target);
        }
    }

    private void deleteSelectedTargets() {
        MessageBox messageBox = new MessageBox(Display.getCurrent().getActiveShell(), 200);
        messageBox.setText("Delete Selected Targets");
        messageBox.setMessage("Do you really want to delete the selected targets?");
        if (messageBox.open() == 64) {
            Table table = this.tableViewer.getTable();
            int[] indices = table.getSelectionIndices();
            Object input = this.tableViewer.getInput();
            if (input instanceof IChromatogramMSD) {
                List<IChromatogramTargetMSD> targetsToRemove = this.getChromatogramTargetList(table, indices);
                IChromatogramMSD chromatogram = (IChromatogramMSD)input;
                chromatogram.removeTargets(targetsToRemove);
                this.tableViewer.refresh();
            } else if (input instanceof IChromatogramPeakMSD) {
                List<IPeakTarget> targetsToRemove = this.getPeakTargetList(table, indices);
                IChromatogramPeakMSD chromatogramPeak = (IChromatogramPeakMSD)input;
                chromatogramPeak.removeTargets(targetsToRemove);
                this.tableViewer.refresh();
            } else if (input instanceof IScanMSD) {
                List<IMassSpectrumTarget> targetsToRemove = this.getMassSpectrumTargetList(table, indices);
                IScanMSD scan = (IScanMSD)input;
                scan.removeTargets(targetsToRemove);
                this.tableViewer.refresh();
            }
        }
    }

    private void manuallyVerifySelectedTargets() {
        Table table = this.tableViewer.getTable();
        int[] indices = table.getSelectionIndices();
        Object input = this.tableViewer.getInput();
        if (input instanceof IChromatogramMSD) {
            List<IChromatogramTargetMSD> chromatogramTargets = this.getChromatogramTargetList(table, indices);
            for (IChromatogramTargetMSD chromatogramTarget : chromatogramTargets) {
                chromatogramTarget.setManuallyVerified(true);
            }
            this.tableViewer.refresh();
        } else if (input instanceof IChromatogramPeakMSD) {
            List<IPeakTarget> peakTargets = this.getPeakTargetList(table, indices);
            for (IPeakTarget peakTarget : peakTargets) {
                peakTarget.setManuallyVerified(true);
            }
            this.tableViewer.refresh();
        } else if (input instanceof IScanMSD) {
            List<IMassSpectrumTarget> massSpectrumTargets = this.getMassSpectrumTargetList(table, indices);
            for (IMassSpectrumTarget massSpectrumTarget : massSpectrumTargets) {
                massSpectrumTarget.setManuallyVerified(true);
            }
            this.tableViewer.refresh();
        }
    }

    private List<IMassSpectrumTarget> getMassSpectrumTargetList(Table table, int[] indices) {
        ArrayList<IMassSpectrumTarget> targetList = new ArrayList<IMassSpectrumTarget>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IMassSpectrumTarget) {
                IMassSpectrumTarget target = (IMassSpectrumTarget)object;
                targetList.add(target);
            }
            ++n2;
        }
        return targetList;
    }

    private List<IPeakTarget> getPeakTargetList(Table table, int[] indices) {
        ArrayList<IPeakTarget> targetList = new ArrayList<IPeakTarget>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IPeakTarget) {
                IPeakTarget target = (IPeakTarget)object;
                targetList.add(target);
            }
            ++n2;
        }
        return targetList;
    }

    private List<IChromatogramTargetMSD> getChromatogramTargetList(Table table, int[] indices) {
        ArrayList<IChromatogramTargetMSD> targetList = new ArrayList<IChromatogramTargetMSD>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            TableItem tableItem = table.getItem(index);
            Object object = tableItem.getData();
            if (object instanceof IChromatogramTargetMSD) {
                IChromatogramTargetMSD target = (IChromatogramTargetMSD)object;
                targetList.add(target);
            }
            ++n2;
        }
        return targetList;
    }

    private void setEditingSupport() {
        TableViewer tableViewer = this.getTableViewer();
        List tableViewerColumns = this.tableViewer.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals(VERIFIED_MANUALLY)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new TargetsViewEditingSupport(tableViewer));
            }
            ++i;
        }
    }
}

