/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.charts;

import org.eclipse.chemclipse.swt.ui.support.Fonts;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.extensions.axisconverter.MillisecondsToMinuteConverter;
import org.eclipse.swtchart.extensions.axisconverter.MillisecondsToSecondsConverter;
import org.eclipse.swtchart.extensions.axisconverter.PercentageConverter;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.IPrimaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.SecondaryAxisSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;

public class ChromatogramChart
extends LineChart {
    private final ChartSupport chartSupport;
    private String titleSeconds = "";
    private String titleMinutes = "";
    private String titleRelativeIntensity = "";
    private final IPreferenceStore preferenceStore;

    public ChromatogramChart() {
        this.preferenceStore = Activator.getDefault().getPreferenceStore();
        this.chartSupport = new ChartSupport(this.preferenceStore);
        this.initialize();
    }

    public ChromatogramChart(Composite parent, int style) {
        this(parent, style, Activator.getDefault().getPreferenceStore());
    }

    public ChromatogramChart(Composite parent, int style, IPreferenceStore preferenceStore) {
        super(parent, style);
        this.chartSupport = new ChartSupport(preferenceStore);
        this.preferenceStore = preferenceStore;
        this.initialize();
    }

    public void modifyAxes(boolean applySettings) {
        this.modifyXAxisMilliseconds();
        this.modifyYAxisIntensity();
        this.modifyXAxisSeconds();
        this.modifyXAxisMinutes();
        this.modifyYAxisRelativeIntensity();
        if (applySettings) {
            IChartSettings chartSettings = this.getChartSettings();
            this.applySettings(chartSettings);
        }
    }

    private void initialize() {
        this.titleSeconds = this.preferenceStore.getString("titleXAxisSeconds");
        this.titleMinutes = this.preferenceStore.getString("titleXAxisMinutes");
        this.titleRelativeIntensity = this.preferenceStore.getString("titleYAxisRelativeIntensity");
        IChartSettings chartSettings = this.getChartSettings();
        chartSettings.setOrientation(256);
        chartSettings.setHorizontalSliderVisible(true);
        chartSettings.setVerticalSliderVisible(false);
        chartSettings.getRangeRestriction().setZeroX(true);
        chartSettings.getRangeRestriction().setZeroY(true);
        this.modifyAxes(true);
    }

    private void modifyXAxisMilliseconds() {
        IChartSettings chartSettings = this.getChartSettings();
        IPrimaryAxisSettings primaryAxisSettingsX = chartSettings.getPrimaryAxisSettingsX();
        primaryAxisSettingsX.setTitle(this.preferenceStore.getString("titleXAxisMilliseconds"));
        String positionNode = "positionXAxisMilliseconds";
        String pattern = "0.0##";
        String colorNode = "colorXAxisMilliseconds";
        String gridLineStyleNode = "gridlineStyleXAxisMilliseconds";
        String gridColorNode = "gridlineColorXAxisMilliseconds";
        this.chartSupport.setAxisSettings((IAxisSettings)primaryAxisSettingsX, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
        primaryAxisSettingsX.setVisible(this.chartSupport.getBoolean("showXAxisMilliseconds"));
        primaryAxisSettingsX.setTitleVisible(this.chartSupport.getBoolean("showXAxisTitleMilliseconds"));
        String name = this.preferenceStore.getString("fontNameXAxisMilliseconds");
        int height = this.preferenceStore.getInt("fontSizeXAxisMilliseconds");
        int style = this.preferenceStore.getInt("fontStyleXAxisMilliseconds");
        primaryAxisSettingsX.setTitleFont(Fonts.getCachedFont((Device)this.getBaseChart().getDisplay(), (String)name, (int)height, (int)style));
    }

    private void modifyYAxisIntensity() {
        IChartSettings chartSettings = this.getChartSettings();
        IPrimaryAxisSettings primaryAxisSettingsY = chartSettings.getPrimaryAxisSettingsY();
        primaryAxisSettingsY.setTitle(this.preferenceStore.getString("titleYAxisIntensity"));
        String positionNode = "positionYAxisIntensity";
        String pattern = "0.0#E0";
        String colorNode = "colorYAxisIntensity";
        String gridLineStyleNode = "gridlineStyleYAxisIntensity";
        String gridColorNode = "gridlineColorYAxisIntensity";
        this.chartSupport.setAxisSettings((IAxisSettings)primaryAxisSettingsY, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
        primaryAxisSettingsY.setVisible(this.chartSupport.getBoolean("showYAxisIntensity"));
        primaryAxisSettingsY.setTitleVisible(this.chartSupport.getBoolean("showYAxisTitleIntensity"));
        String name = this.preferenceStore.getString("fontNameYAxisIntensity");
        int height = this.preferenceStore.getInt("fontSizeYAxisIntensity");
        int style = this.preferenceStore.getInt("fontStyleYAxisIntensity");
        primaryAxisSettingsY.setTitleFont(Fonts.getCachedFont((Device)this.getBaseChart().getDisplay(), (String)name, (int)height, (int)style));
    }

    private void modifyYAxisRelativeIntensity() {
        IChartSettings chartSettings = this.getChartSettings();
        ISecondaryAxisSettings axisSettings = this.chartSupport.getSecondaryAxisSettingsY(this.titleRelativeIntensity, chartSettings);
        String positionNode = "positionYAxisRelativeIntensity";
        String pattern = "0.00";
        String colorNode = "colorYAxisRelativeIntensity";
        String gridLineStyleNode = "gridlineStyleYAxisRelativeIntensity";
        String gridColorNode = "gridlineColorYAxisRelativeIntensity";
        boolean isShowAxis = this.chartSupport.getBoolean("showYAxisRelativeIntensity");
        boolean isShowAxisTitle = this.chartSupport.getBoolean("showYAxisTitleRelativeIntensity");
        String title = this.preferenceStore.getString("titleYAxisRelativeIntensity");
        String name = this.preferenceStore.getString("fontNameYAxisRelativeIntensity");
        int height = this.preferenceStore.getInt("fontSizeYAxisRelativeIntensity");
        int style = this.preferenceStore.getInt("fontStyleYAxisRelativeIntensity");
        Font titleFont = Fonts.getCachedFont((Device)this.getBaseChart().getDisplay(), (String)name, (int)height, (int)style);
        if (isShowAxis) {
            if (axisSettings == null) {
                SecondaryAxisSettings secondaryAxisSettingsY = new SecondaryAxisSettings(title, (IAxisScaleConverter)new PercentageConverter(512, true));
                this.chartSupport.setAxisSettings((IAxisSettings)secondaryAxisSettingsY, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                secondaryAxisSettingsY.setTitleVisible(isShowAxisTitle);
                secondaryAxisSettingsY.setTitleFont(titleFont);
                chartSettings.getSecondaryAxisSettingsListY().add(secondaryAxisSettingsY);
            } else {
                this.chartSupport.setAxisSettings((IAxisSettings)axisSettings, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                axisSettings.setTitle(title);
                axisSettings.setTitleFont(titleFont);
                axisSettings.setVisible(true);
                axisSettings.setTitleVisible(isShowAxisTitle);
            }
        } else if (axisSettings != null) {
            axisSettings.setTitle(title);
            axisSettings.setTitleFont(titleFont);
            axisSettings.setVisible(false);
            axisSettings.setTitleVisible(isShowAxisTitle);
        }
        this.titleRelativeIntensity = title;
    }

    private void modifyXAxisSeconds() {
        IChartSettings chartSettings = this.getChartSettings();
        ISecondaryAxisSettings axisSettings = this.chartSupport.getSecondaryAxisSettingsX(this.titleSeconds, chartSettings);
        String positionNode = "positionXAxisSeconds";
        String pattern = "0.00";
        String colorNode = "colorXAxisSeconds";
        String gridLineStyleNode = "gridlineStyleXAxisSeconds";
        String gridColorNode = "gridlineColorXAxisSeconds";
        boolean isShowAxis = this.chartSupport.getBoolean("showXAxisSeconds");
        boolean isShowAxisTitle = this.chartSupport.getBoolean("showXAxisTitleSeconds");
        String title = this.preferenceStore.getString("titleXAxisSeconds");
        String name = this.preferenceStore.getString("fontNameXAxisSeconds");
        int height = this.preferenceStore.getInt("fontSizeXAxisSeconds");
        int style = this.preferenceStore.getInt("fontStyleXAxisSeconds");
        Font titleFont = Fonts.getCachedFont((Device)this.getBaseChart().getDisplay(), (String)name, (int)height, (int)style);
        if (isShowAxis) {
            if (axisSettings == null) {
                SecondaryAxisSettings secondaryAxisSettingsX = new SecondaryAxisSettings(title, (IAxisScaleConverter)new MillisecondsToSecondsConverter());
                this.chartSupport.setAxisSettings((IAxisSettings)secondaryAxisSettingsX, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                secondaryAxisSettingsX.setTitleFont(titleFont);
                secondaryAxisSettingsX.setTitleVisible(isShowAxisTitle);
                chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX);
            } else {
                this.chartSupport.setAxisSettings((IAxisSettings)axisSettings, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                axisSettings.setTitle(title);
                axisSettings.setTitleFont(titleFont);
                axisSettings.setVisible(true);
                axisSettings.setTitleVisible(isShowAxisTitle);
            }
        } else if (axisSettings != null) {
            axisSettings.setTitle(title);
            axisSettings.setTitleFont(titleFont);
            axisSettings.setVisible(false);
            axisSettings.setTitleVisible(isShowAxisTitle);
        }
        this.titleSeconds = title;
    }

    private void modifyXAxisMinutes() {
        IChartSettings chartSettings = this.getChartSettings();
        ISecondaryAxisSettings axisSettings = this.chartSupport.getSecondaryAxisSettingsX(this.titleMinutes, chartSettings);
        String positionNode = "positionXAxisMinutes";
        String pattern = "0.00";
        String colorNode = "colorXAxisMinutes";
        String gridLineStyleNode = "gridlineStyleXAxisMinutes";
        String gridColorNode = "gridlineColorXAxisMinutes";
        boolean isShowAxis = this.chartSupport.getBoolean("showXAxisMinutes");
        boolean isShowAxisTitle = this.chartSupport.getBoolean("showXAxisTitleMinutes");
        String title = this.preferenceStore.getString("titleXAxisMinutes");
        String name = this.preferenceStore.getString("fontNameXAxisMinutes");
        int height = this.preferenceStore.getInt("fontSizeXAxisMinutes");
        int style = this.preferenceStore.getInt("fontStyleXAxisMinutes");
        Font titleFont = Fonts.getCachedFont((Device)this.getBaseChart().getDisplay(), (String)name, (int)height, (int)style);
        if (isShowAxis) {
            if (axisSettings == null) {
                SecondaryAxisSettings secondaryAxisSettingsX = new SecondaryAxisSettings(title, (IAxisScaleConverter)new MillisecondsToMinuteConverter());
                this.chartSupport.setAxisSettings((IAxisSettings)secondaryAxisSettingsX, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                secondaryAxisSettingsX.setTitleFont(titleFont);
                secondaryAxisSettingsX.setTitleVisible(isShowAxisTitle);
                chartSettings.getSecondaryAxisSettingsListX().add(secondaryAxisSettingsX);
            } else {
                this.chartSupport.setAxisSettings((IAxisSettings)axisSettings, positionNode, pattern, colorNode, gridLineStyleNode, gridColorNode);
                axisSettings.setTitle(title);
                axisSettings.setTitleFont(titleFont);
                axisSettings.setVisible(true);
                axisSettings.setTitleVisible(isShowAxisTitle);
            }
        } else if (axisSettings != null) {
            axisSettings.setTitle(title);
            axisSettings.setTitleFont(titleFont);
            axisSettings.setVisible(false);
            axisSettings.setTitleVisible(isShowAxisTitle);
        }
        this.titleMinutes = title;
    }

    public static IPreferenceStore initializeDefaults(IPreferenceStore preferenceStore) {
        preferenceStore.setDefault("titleXAxisSeconds", "Time [s]");
        preferenceStore.setDefault("showXAxisSeconds", false);
        preferenceStore.setDefault("positionXAxisSeconds", PreferenceConstants.DEF_POSITION_X_AXIS_SECONDS);
        preferenceStore.setDefault("colorXAxisSeconds", "0,0,0");
        preferenceStore.setDefault("fontNameXAxisSeconds", "Tahoma");
        preferenceStore.setDefault("fontSizeXAxisSeconds", 11);
        preferenceStore.setDefault("fontStyleXAxisSeconds", 1);
        preferenceStore.setDefault("gridlineStyleXAxisSeconds", PreferenceConstants.DEF_GRIDLINE_STYLE_X_AXIS_SECONDS);
        preferenceStore.setDefault("gridlineColorXAxisSeconds", "192,192,192");
        preferenceStore.setDefault("showXAxisTitleSeconds", true);
        preferenceStore.setDefault("titleXAxisMinutes", "Time [min]");
        preferenceStore.setDefault("showXAxisMinutes", true);
        preferenceStore.setDefault("positionXAxisMinutes", PreferenceConstants.DEF_POSITION_X_AXIS_MINUTES);
        preferenceStore.setDefault("colorXAxisMinutes", "0,0,0");
        preferenceStore.setDefault("fontNameXAxisMinutes", "Tahoma");
        preferenceStore.setDefault("fontSizeXAxisMinutes", 11);
        preferenceStore.setDefault("fontStyleXAxisMinutes", 1);
        preferenceStore.setDefault("gridlineStyleXAxisMinutes", PreferenceConstants.DEF_GRIDLINE_STYLE_X_AXIS_MINUTES);
        preferenceStore.setDefault("gridlineColorXAxisMinutes", "192,192,192");
        preferenceStore.setDefault("showXAxisTitleMinutes", true);
        preferenceStore.setDefault("titleYAxisRelativeIntensity", "Intensity [%]");
        preferenceStore.setDefault("showYAxisRelativeIntensity", true);
        preferenceStore.setDefault("positionYAxisRelativeIntensity", PreferenceConstants.DEF_POSITION_Y_AXIS_RELATIVE_INTENSITY);
        preferenceStore.setDefault("colorYAxisRelativeIntensity", "0,0,0");
        preferenceStore.setDefault("fontNameYAxisRelativeIntensity", "Tahoma");
        preferenceStore.setDefault("fontSizeYAxisRelativeIntensity", 11);
        preferenceStore.setDefault("fontStyleYAxisRelativeIntensity", 1);
        preferenceStore.setDefault("gridlineStyleYAxisRelativeIntensity", PreferenceConstants.DEF_GRIDLINE_STYLE_Y_AXIS_RELATIVE_INTENSITY);
        preferenceStore.setDefault("gridlineColorYAxisRelativeIntensity", "192,192,192");
        preferenceStore.setDefault("showYAxisTitleRelativeIntensity", true);
        preferenceStore.setDefault("titleXAxisMilliseconds", "Time [ms]");
        preferenceStore.setDefault("showXAxisMilliseconds", false);
        preferenceStore.setDefault("positionXAxisMilliseconds", PreferenceConstants.DEF_POSITION_X_AXIS_MILLISECONDS);
        preferenceStore.setDefault("colorXAxisMilliseconds", "0,0,0");
        preferenceStore.setDefault("fontNameXAxisMilliseconds", "Tahoma");
        preferenceStore.setDefault("fontSizeXAxisMilliseconds", 11);
        preferenceStore.setDefault("fontStyleXAxisMilliseconds", 1);
        preferenceStore.setDefault("gridlineStyleXAxisMilliseconds", PreferenceConstants.DEF_GRIDLINE_STYLE_X_AXIS_MILLISECONDS);
        preferenceStore.setDefault("gridlineColorXAxisMilliseconds", "192,192,192");
        preferenceStore.setDefault("showXAxisTitleMilliseconds", true);
        preferenceStore.setDefault("titleYAxisIntensity", "Intensity [counts]");
        preferenceStore.setDefault("showYAxisIntensity", true);
        preferenceStore.setDefault("positionYAxisIntensity", PreferenceConstants.DEF_POSITION_Y_AXIS_INTENSITY);
        preferenceStore.setDefault("colorYAxisIntensity", "0,0,0");
        preferenceStore.setDefault("fontNameYAxisIntensity", "Tahoma");
        preferenceStore.setDefault("fontSizeYAxisIntensity", 11);
        preferenceStore.setDefault("fontStyleYAxisIntensity", 1);
        preferenceStore.setDefault("gridlineStyleYAxisIntensity", PreferenceConstants.DEF_GRIDLINE_STYLE_Y_AXIS_INTENSITY);
        preferenceStore.setDefault("gridlineColorYAxisIntensity", "192,192,192");
        preferenceStore.setDefault("showYAxisTitleIntensity", true);
        return preferenceStore;
    }
}

