/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ChromatogramScanInfoLabelProvider
extends AbstractChemClipseLabelProvider {
    private static final int MAX_SIM_IONS = 10;
    private StringBuilder builder = new StringBuilder();

    public ChromatogramScanInfoLabelProvider() {
        super("0.000");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        String text = "";
        if (element instanceof IScanMSD) {
            IScanMSD scanMSD = (IScanMSD)element;
            switch (columnIndex) {
                case 0: {
                    text = Integer.toString(scanMSD.getScanNumber());
                    break;
                }
                case 1: {
                    text = decimalFormat.format((double)scanMSD.getRetentionTime() / 60000.0);
                    break;
                }
                case 2: {
                    text = Integer.toString(scanMSD.getNumberOfIons());
                    break;
                }
                case 3: {
                    text = scanMSD.getNumberOfIons() <= 10 ? "SIM" : "SCAN";
                    break;
                }
                case 4: {
                    text = scanMSD.getNumberOfIons() <= 10 ? this.getIons(scanMSD) : "";
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    private String getIons(IScanMSD scanMSD) {
        this.builder.delete(0, this.builder.length());
        ArrayList<Integer> ions = new ArrayList<Integer>();
        for (IIon ion : scanMSD.getIons()) {
            ions.add((int)Math.round(ion.getIon()));
        }
        Collections.sort(ions);
        Iterator iterator = ions.iterator();
        while (iterator.hasNext()) {
            this.builder.append(Integer.toString((Integer)iterator.next()));
            if (!iterator.hasNext()) continue;
            this.builder.append(" ");
        }
        return this.builder.toString();
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/massSpectrum.gif", "16x16");
    }
}

