/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.model.ColorCode;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ColorCodeDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(ColorCodeDialog.class);
    private Text textName;
    private Label colorWidget;
    private ColorCode colorCode;

    public ColorCodeDialog(Shell shell) {
        this(shell, null);
    }

    public ColorCodeDialog(Shell shell, ColorCode colorCodePCR) {
        super(shell);
        this.colorCode = colorCodePCR;
    }

    public ColorCode getColorCode() {
        return this.colorCode;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Color Code");
        this.validate();
        return contents;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                this.colorCode = new ColorCode(this.getName(), this.getColor());
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite compositeMain = new Composite(composite, 4);
        compositeMain.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(512);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 550;
        composite.setLayoutData((Object)gridData);
        this.createTextElement(compositeMain);
        this.createColorDisplayElement(compositeMain);
        this.createColorButtonElement(compositeMain);
        return composite;
    }

    private void createTextElement(Composite parent) {
        this.textName = new Text(parent, 2048);
        this.textName.setText(this.colorCode != null ? this.colorCode.getName() : "");
        this.textName.setToolTipText("This is the field for the color code name.");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 300;
        this.textName.setLayoutData((Object)gridData);
        this.textName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ColorCodeDialog.this.validate();
            }
        });
    }

    private void createColorDisplayElement(Composite parent) {
        this.colorWidget = new Label(parent, 2048);
        this.colorWidget.setText("");
        this.colorWidget.setToolTipText("This color is used.");
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 150;
        this.colorWidget.setLayoutData((Object)gridData);
        this.colorWidget.setBackground(this.colorCode != null ? this.colorCode.getColor() : Colors.BLACK);
    }

    private void createColorButtonElement(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Color");
        button.setToolTipText("Select the color.");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog colorDialog = new ColorDialog(event.display.getActiveShell());
                colorDialog.setRGB(ColorCodeDialog.this.colorWidget.getBackground().getRGB());
                colorDialog.setText("Select a color.");
                RGB rgb = colorDialog.open();
                if (rgb != null) {
                    Color color = Colors.getColor((RGB)rgb);
                    ColorCodeDialog.this.colorWidget.setBackground(color);
                }
            }
        });
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    private void validate() {
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        String name = this.getName();
        if (name.equals("")) {
            this.setErrorMessage("A name must be specified.");
            this.getButton(0).setEnabled(false);
        } else if (name.contains(":")) {
            this.setErrorMessage("The name must not contain: ':'");
            this.getButton(0).setEnabled(false);
        } else if (name.contains(";")) {
            this.setErrorMessage("The name must not contain: ';'");
            this.getButton(0).setEnabled(false);
        }
    }

    private String getName() {
        return this.textName.getText().trim();
    }

    private Color getColor() {
        return this.colorWidget.getBackground();
    }
}

