/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.part.support;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractDataUpdateSupport
extends AbstractUpdateSupport
implements IDataUpdateSupport {
    private static final Logger logger = Logger.getLogger(AbstractDataUpdateSupport.class);
    private final List<Object> objects = new ArrayList<Object>();
    private String topic = "";
    private final IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
    private final List<EventHandler> registeredEventHandler = new ArrayList<EventHandler>();

    public AbstractDataUpdateSupport(MPart part) {
        this(part, false);
    }

    public AbstractDataUpdateSupport(MPart part, boolean handlePartCloseEvent) {
        super(part);
        if (handlePartCloseEvent) {
            this.handlePartCloseEvent(part);
        }
        this.registerEvents();
    }

    public void registerEvent(String topic, String property) {
        this.registerEvent(topic, new String[]{property});
    }

    public void registerEvent(String topic, String[] properties) {
        if (this.eventBroker != null) {
            this.registeredEventHandler.add(this.registerEventHandler(this.eventBroker, topic, properties));
        }
    }

    @Override
    public List<Object> getObjects() {
        return this.objects;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @PreDestroy
    protected void preDestroy() {
        if (this.eventBroker != null) {
            for (EventHandler eventHandler : this.registeredEventHandler) {
                this.eventBroker.unsubscribe(eventHandler);
            }
        }
    }

    private void handlePartCloseEvent(final MPart myPart) {
        if (myPart != null) {
            EventHandler partCloseHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    MPart part;
                    Object object = event.getProperty("ChangedElement");
                    boolean toBeRendered = (Boolean)event.getProperty("NewValue");
                    if (object instanceof MPart && (part = (MPart)object).getElementId().equals(myPart.getElementId()) && part.isCloseable() && !toBeRendered) {
                        PartSupport.setPartVisibility((MPart)part, (boolean)false, (IEventBroker)AbstractDataUpdateSupport.this.eventBroker);
                    }
                }
            };
            this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", partCloseHandler);
            this.registeredEventHandler.add(partCloseHandler);
        }
    }

    private EventHandler registerEventHandler(IEventBroker eventBroker, final String topic, final String[] properties) {
        EventHandler eventHandler = new EventHandler(){

            public void handleEvent(Event event) {
                try {
                    AbstractDataUpdateSupport.this.objects.clear();
                    AbstractDataUpdateSupport.this.topic = topic;
                    String[] stringArray = properties;
                    int n = properties.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String property = stringArray[n2];
                        Object object = event.getProperty(property);
                        AbstractDataUpdateSupport.this.objects.add(object);
                        ++n2;
                    }
                    AbstractDataUpdateSupport.this.update(topic);
                }
                catch (Exception e) {
                    logger.warn((Object)(e + "\t" + event));
                }
            }
        };
        eventBroker.subscribe(topic, eventHandler);
        return eventHandler;
    }

    private void update(String topic) {
        if (this.doUpdate()) {
            this.updateObjects(this.objects, topic);
        }
    }
}

