/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.parts;

import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.signals.ITotalScanSignal;
import org.eclipse.chemclipse.model.signals.ITotalScanSignals;
import org.eclipse.chemclipse.model.signals.TotalScanSignalExtractor;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.AbstractOverviewUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.part.support.IDataUpdateSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.swt.OverviewChartUI;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.SeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineSeriesData;

public class ChromatogramOverviewPart
extends AbstractOverviewUpdateSupport
implements IDataUpdateSupport {
    private OverviewChartUI chromatogramOverviewChart;

    @Inject
    public ChromatogramOverviewPart(Composite parent, MPart part) {
        super(part);
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateObjects(this.getObjects(), this.getTopic());
    }

    @Override
    public void update(Object object) {
        this.chromatogramOverviewChart.deleteSeries();
        if (object instanceof IChromatogramOverview) {
            IChromatogramOverview chromatogramOverview = (IChromatogramOverview)object;
            ArrayList<LineSeriesData> lineSeriesDataList = new ArrayList<LineSeriesData>();
            ISeriesData seriesData = this.getSeriesData(chromatogramOverview);
            LineSeriesData lineSeriesData = new LineSeriesData(seriesData);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setEnableArea(false);
            ILineSeriesSettings lineSeriesSettingsHighlight = (ILineSeriesSettings)lineSeriesSettings.getSeriesSettingsHighlight();
            lineSeriesSettingsHighlight.setLineWidth(2);
            lineSeriesDataList.add(lineSeriesData);
            this.chromatogramOverviewChart.addSeriesData(lineSeriesDataList);
        }
    }

    private void initialize(Composite parent) {
        this.chromatogramOverviewChart = new OverviewChartUI(parent, 0);
    }

    private ISeriesData getSeriesData(IChromatogramOverview chromatogramOverview) {
        String seriesId = chromatogramOverview.getName();
        TotalScanSignalExtractor totalSignalExtractor = new TotalScanSignalExtractor(chromatogramOverview);
        ITotalScanSignals totalScanSignals = totalSignalExtractor.getTotalScanSignals(false);
        int size = totalScanSignals.size();
        double[] xSeries = new double[size];
        double[] ySeries = new double[size];
        int i = 0;
        for (ITotalScanSignal totalScanSignal : totalScanSignals.getTotalScanSignals()) {
            xSeries[i] = totalScanSignal.getRetentionTime();
            ySeries[i] = totalScanSignal.getTotalSignal();
            ++i;
        }
        return new SeriesData(xSeries, ySeries, seriesId);
    }
}

