/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.ranges;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.marker.AbstractBaseChartPaintListener;
import org.eclipse.swtchart.extensions.marker.IBaseChartPaintListener;

public class TimeRangeMarker
extends AbstractBaseChartPaintListener
implements IBaseChartPaintListener {
    private static final int INVISIBLE = -1;
    private Set<TimeRange> timeRanges = new HashSet<TimeRange>();
    private Transform transform = new Transform((Device)Display.getDefault());
    private boolean plotCenterOnly = false;

    public TimeRangeMarker(BaseChart baseChart) {
        super(baseChart);
        this.transform.rotate(-90.0f);
    }

    public Set<TimeRange> getTimeRanges() {
        return this.timeRanges;
    }

    public boolean isPlotCenterOnly() {
        return this.plotCenterOnly;
    }

    public void setPlotCenterOnly(boolean plotCenterOnly) {
        this.plotCenterOnly = plotCenterOnly;
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        for (TimeRange timeRange : this.timeRanges) {
            this.plotMarker(gc, timeRange);
        }
        gc.setAlpha(255);
    }

    protected void finalize() throws Throwable {
        this.transform.dispose();
        super.finalize();
    }

    private void plotMarker(GC gc, TimeRange timeRange) {
        BaseChart baseChart = this.getBaseChart();
        if (baseChart.getSeriesSet().getSeries().length > 0) {
            IAxis xAxis = baseChart.getAxisSet().getXAxis(0);
            IAxis yAxis = baseChart.getAxisSet().getXAxis(0);
            if (xAxis != null && yAxis != null) {
                Point rectangle;
                Range rangeX = xAxis.getRange();
                IPlotArea plotArea = baseChart.getPlotArea();
                Point point = rectangle = plotArea instanceof Scrollable ? ((Scrollable)plotArea).getSize() : plotArea.getSize();
                if (this.plotCenterOnly) {
                    int xStop = this.printLine(gc, rectangle, rangeX, timeRange.getCenter(), Colors.DARK_GRAY, 1);
                    this.printLabel(gc, rectangle, timeRange.getIdentifier(), xStop, Colors.DARK_GRAY);
                } else {
                    int xStart = this.printLine(gc, rectangle, rangeX, timeRange.getStart(), Colors.DARK_GRAY, 1);
                    this.printLine(gc, rectangle, rangeX, timeRange.getCenter(), Colors.GRAY, 1);
                    int xStop = this.printLine(gc, rectangle, rangeX, timeRange.getStop(), Colors.DARK_GRAY, 1);
                    this.fillRectangle(gc, rectangle, xStart, xStop, Colors.GRAY);
                    this.printLabel(gc, rectangle, timeRange.getIdentifier(), xStop, Colors.DARK_GRAY);
                }
            }
        }
    }

    private int printLine(GC gc, Point rectangle, Range rangeX, int position, Color color, int lineWidth) {
        int x = -1;
        if (this.isMarkerInRange(rangeX, position)) {
            x = this.calculatePositionX(rangeX, rectangle, position);
            gc.setAlpha(255);
            gc.setForeground(color);
            gc.setLineWidth(lineWidth);
            gc.drawLine(x, 0, x, rectangle.y);
        }
        return x;
    }

    private void fillRectangle(GC gc, Point rectangle, int xStart, int xStop, Color color) {
        if (xStart > -1 || xStop > -1) {
            int start = xStart == -1 ? 0 : xStart;
            int stop = xStop == -1 ? rectangle.x : xStop;
            gc.setBackground(color);
            gc.setAlpha(50);
            gc.fillRectangle(start, 0, stop - start, rectangle.y);
        }
    }

    private void printLabel(GC gc, Point rectangle, String label, int xStop, Color color) {
        if (xStop > -1) {
            gc.setTransform(this.transform);
            Point labelSize = gc.textExtent(label);
            int xLabel = -labelSize.x - (rectangle.y - labelSize.x) + rectangle.y / 20;
            int yLabel = xStop;
            gc.setAlpha(255);
            gc.setForeground(color);
            gc.setLineWidth(1);
            gc.drawText(label, xLabel, yLabel, true);
            gc.setTransform(null);
        }
    }

    private boolean isMarkerInRange(Range range, int x) {
        return (double)x >= range.lower && (double)x <= range.upper;
    }

    private int calculatePositionX(Range range, Point point, int x) {
        int position = 0;
        double deltaRange = range.upper - range.lower + 1.0;
        if (deltaRange != 0.0) {
            double partSize = (double)point.x / deltaRange;
            double deltaX = (double)x - range.lower;
            position = (int)(deltaX * partSize);
        }
        return position;
    }
}

