/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.ranges;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.chemclipse.model.comparator.TimeRangeComparator;
import org.eclipse.chemclipse.model.ranges.TimeRange;
import org.eclipse.chemclipse.model.ranges.TimeRanges;
import org.eclipse.chemclipse.model.updates.IUpdateListener;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.validation.TimeRangeInputValidator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePageTimeRanges;
import org.eclipse.chemclipse.ux.extension.xxd.ui.ranges.TimeSpinner;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TimeRangesUI
extends Composite {
    private ComboViewer comboViewer;
    private TimeSpinner timeSpinnerStart;
    private TimeSpinner timeSpinnerCenter;
    private TimeSpinner timeSpinnerStop;
    private Button buttonAdd;
    private Button buttonDelete;
    private Button buttonSettings;
    private TimeRanges timeRanges = null;
    private TimeRange timeRange = null;
    private IUpdateListener updateListener = null;

    public TimeRangesUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void setInput(TimeRanges timeRanges) {
        this.timeRanges = timeRanges;
        this.updateInput();
        this.updateLabels();
    }

    public void update() {
        super.update();
        this.updateTimeRange();
        this.updateLabels();
    }

    public void setUpdateListener(IUpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public String[] getItems() {
        return this.comboViewer.getCombo().getItems();
    }

    public void select(int index) {
        if (index >= 0 && index < this.getItems().length) {
            this.comboViewer.getCombo().select(index);
            Object object = this.comboViewer.getStructuredSelection().getFirstElement();
            if (object instanceof TimeRange) {
                this.timeRange = (TimeRange)object;
                this.updateTimeRange();
            }
        }
    }

    private void createControl() {
        GridLayout gridLayout = new GridLayout(8, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        this.setLayout((Layout)gridLayout);
        this.comboViewer = this.createComboViewer(this);
        this.timeSpinnerStart = this.createSpinner(this, TimeRange.Marker.START);
        this.timeSpinnerCenter = this.createSpinner(this, TimeRange.Marker.CENTER);
        this.timeSpinnerStop = this.createSpinner(this, TimeRange.Marker.STOP);
        this.createSeparator(this);
        this.buttonAdd = this.createButtonAdd(this);
        this.buttonDelete = this.createButtonDelete(this);
        this.buttonSettings = this.createButtonSettings(this);
    }

    private ComboViewer createComboViewer(Composite composite) {
        final ComboViewer comboViewer = new ComboViewer(composite, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TimeRange) {
                    TimeRange timeRange = (TimeRange)element;
                    return timeRange.getIdentifier();
                }
                return null;
            }
        });
        combo.setToolTipText("Select a time range.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 150;
        combo.setLayoutData((Object)gridData);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object = comboViewer.getStructuredSelection().getFirstElement();
                if (object instanceof TimeRange) {
                    TimeRangesUI.this.timeRange = (TimeRange)object;
                    TimeRangesUI.this.updateTimeRange();
                }
            }
        });
        return comboViewer;
    }

    private TimeSpinner createSpinner(Composite composite, TimeRange.Marker marker) {
        TimeSpinner timeSpinner = new TimeSpinner(composite, 0, marker);
        timeSpinner.setLayoutData(new GridData(768));
        timeSpinner.setUpdateListener(new IUpdateListener(){

            public void update() {
                TimeRangesUI.this.fireUpdate();
            }
        });
        return timeSpinner;
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Add a new time range.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog;
                if (TimeRangesUI.this.timeRanges != null && (dialog = new InputDialog(e.display.getActiveShell(), "Time Range", "Create a new time range.", "C10 | 10.2 | 10.4 | 10.6", (IInputValidator)new TimeRangeInputValidator(TimeRangesUI.this.timeRanges.keySet()))).open() == 0) {
                    String item = dialog.getValue();
                    TimeRange timeRangeNew = TimeRangesUI.this.timeRanges.extractTimeRange(item);
                    if (timeRangeNew != null) {
                        TimeRangesUI.this.timeRanges.add(timeRangeNew);
                        TimeRangesUI.this.updateInput();
                        TimeRangesUI.this.comboViewer.getCombo().setText(timeRangeNew.getIdentifier());
                        TimeRangesUI.this.timeRange = timeRangeNew;
                        TimeRangesUI.this.fireUpdate();
                    }
                }
            }
        });
        return button;
    }

    private Label createSeparator(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText("|");
        label.setForeground(Colors.GRAY);
        return label;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete the selected time range.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/delete.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object object;
                if (MessageDialog.openQuestion((Shell)e.display.getActiveShell(), (String)"Time Range", (String)"Would you like to delete the selected time range?") && (object = TimeRangesUI.this.comboViewer.getStructuredSelection().getFirstElement()) instanceof TimeRange) {
                    TimeRangesUI.this.timeRanges.remove((TimeRange)object);
                    TimeRangesUI.this.updateInput();
                    TimeRangesUI.this.fireUpdate();
                }
            }
        });
        return button;
    }

    private Button createButtonSettings(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Settings");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)new PreferencePageTimeRanges()));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        TimeRangesUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
        return button;
    }

    private void applySettings() {
        this.updateLabels();
    }

    private void updateLabels() {
        this.timeSpinnerStart.update();
        this.timeSpinnerCenter.update();
        this.timeSpinnerStop.update();
        Composite parent = this.getParent();
        if (parent != null && this.getParent() != null) {
            parent = this.getParent();
        }
        if (parent != null) {
            parent.layout(true);
            parent.redraw();
        }
    }

    private void updateInput() {
        this.timeRange = null;
        if (this.timeRanges != null) {
            this.buttonAdd.setEnabled(true);
            ArrayList ranges = new ArrayList(this.timeRanges.values());
            Collections.sort(ranges, new TimeRangeComparator());
            Combo combo = this.comboViewer.getCombo();
            int selectionIndex = combo.getSelectionIndex();
            this.comboViewer.setInput(ranges);
            if (combo.getItemCount() > 0) {
                this.buttonDelete.setEnabled(true);
                int index = selectionIndex >= 0 && selectionIndex < combo.getItemCount() ? selectionIndex : 0;
                combo.select(index);
                this.timeRange = (TimeRange)ranges.get(index);
            } else {
                this.buttonDelete.setEnabled(false);
            }
        } else {
            this.buttonAdd.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.comboViewer.setInput(null);
        }
        this.updateTimeRange();
    }

    private void updateTimeRange() {
        this.timeSpinnerStart.update(this.timeRange);
        this.timeSpinnerCenter.update(this.timeRange);
        this.timeSpinnerStop.update(this.timeRange);
        this.buttonDelete.setEnabled(this.timeRange != null);
        this.buttonSettings.setEnabled(true);
    }

    private void fireUpdate() {
        if (this.updateListener != null) {
            this.updateTimeRange();
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TimeRangesUI.this.updateListener.update();
                }
            });
        }
    }
}

