/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.swt.EditorToolBar;
import org.eclipse.chemclipse.ux.extension.xxd.ui.dialogs.ChromatogramEditorDialog;
import org.eclipse.chemclipse.ux.extension.xxd.ui.dialogs.TargetTransferDialog;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.ChromatogramSelectionWSD;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;

public class ChromatogramReferencesUI {
    private Action buttonPrevious;
    private final ComboContainer comboChromatograms;
    private Action buttonNext;
    private Action buttonAdd;
    private Action buttonRemove;
    private Action buttonTargetTransfer;
    private final EditorToolBar toolBar;

    public ChromatogramReferencesUI(EditorToolBar editorToolBar, Consumer<IChromatogramSelection<?, ?>> chromatogramReferencesListener) {
        this.comboChromatograms = new ComboContainer(chromatogramReferencesListener.andThen(t -> this.updateButtons()));
        Action action = new Action("References", 2){

            public void run() {
                ChromatogramReferencesUI.this.toolBar.setVisible(this.isChecked());
            }

            public void setChecked(boolean checked) {
                if (checked) {
                    this.setToolTipText("Collapse the references items");
                    this.setImageDescriptor(ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/collapse_all.gif", "16x16"));
                } else {
                    this.setToolTipText("Expand the references items");
                    this.setImageDescriptor(ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/expand_all.gif", "16x16"));
                }
                super.setChecked(checked);
            }
        };
        editorToolBar.addAction((IAction)action);
        action.setChecked(false);
        this.toolBar = editorToolBar.createChild();
        this.initialize();
    }

    private void createComboChromatograms(EditorToolBar toolBar) {
        toolBar.createCombo(viewer -> {
            ComboViewer oldViewer = this.comboChromatograms.viewerReferenece.getAndSet(viewer);
            if (oldViewer != null) {
                oldViewer.removeSelectionChangedListener((ISelectionChangedListener)this.comboChromatograms);
            }
            viewer.addSelectionChangedListener((ISelectionChangedListener)this.comboChromatograms);
            Control control = viewer.getControl();
            control.setToolTipText("Select a referenced chromatogram.");
            control.addDisposeListener(new DisposeListener((ComboViewer)viewer){
                private final /* synthetic */ ComboViewer val$viewer;
                {
                    this.val$viewer = comboViewer;
                }

                public void widgetDisposed(DisposeEvent e) {
                    if (ChromatogramReferencesUI.this.comboChromatograms.viewerReferenece.compareAndSet(this.val$viewer, null)) {
                        this.val$viewer.removeSelectionChangedListener((ISelectionChangedListener)ChromatogramReferencesUI.this.comboChromatograms);
                        ChromatogramReferencesUI.this.comboChromatograms.refreshUI();
                    }
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IChromatogramSelection) {
                        IChromatogramSelection selection = (IChromatogramSelection)element;
                        String type = ChromatogramDataSupport.getChromatogramType(selection);
                        int index = ChromatogramReferencesUI.this.comboChromatograms.indexOf(selection);
                        if (index > -1) {
                            String dataName = selection.getChromatogram().getDataName();
                            if (dataName != null && !dataName.isEmpty()) {
                                return String.valueOf(dataName) + " " + type;
                            }
                            if (index == 0) {
                                return "Master Chromatogram " + type;
                            }
                            return "Referenced Chromatogram (" + index + ") " + type;
                        }
                    }
                    return "N/A";
                }
            });
            this.comboChromatograms.refreshUI();
        }, true, 300);
    }

    public void setMasterChromatogram(IChromatogramSelection<?, ?> chromatogramSelection) {
        if (this.comboChromatograms.master != chromatogramSelection) {
            this.comboChromatograms.master = chromatogramSelection;
            if (chromatogramSelection == null) {
                this.comboChromatograms.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
                this.comboChromatograms.setInput(Collections.emptyList());
            } else {
                this.update();
                this.comboChromatograms.setSelection((IStructuredSelection)new StructuredSelection(chromatogramSelection));
            }
            this.updateButtons();
        }
    }

    private void initialize() {
        this.buttonPrevious = this.createButtonSelectPreviousChromatogram(this.toolBar);
        this.createComboChromatograms(this.toolBar);
        this.buttonNext = this.createButtonSelectNextChromatogram(this.toolBar);
        this.buttonRemove = this.createButtonRemoveReference(this.toolBar);
        this.buttonAdd = this.createButtonAddReference(this.toolBar);
        this.buttonTargetTransfer = this.createButtonTargetTransfer(this.toolBar);
        this.toolBar.addSeparator();
    }

    private Action createButtonSelectPreviousChromatogram(EditorToolBar toolBar) {
        Action action = new Action("Previous", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/arrowBackward.gif", "16x16")){
            {
                this.setToolTipText("Select previous chromatogram.");
            }

            public void run() {
                int index = ChromatogramReferencesUI.this.comboChromatograms.currentIndex();
                ChromatogramReferencesUI.this.comboChromatograms.selectChromatogram(index - 1);
                ChromatogramReferencesUI.this.updateButtons();
            }
        };
        toolBar.addAction((IAction)action);
        return action;
    }

    private Action createButtonSelectNextChromatogram(EditorToolBar toolBar) {
        Action action = new Action("Next", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/arrowForward.gif", "16x16")){
            {
                this.setToolTipText("Select next chromatogram.");
            }

            public void run() {
                int index = ChromatogramReferencesUI.this.comboChromatograms.currentIndex();
                ChromatogramReferencesUI.this.comboChromatograms.selectChromatogram(index + 1);
                ChromatogramReferencesUI.this.updateButtons();
            }
        };
        toolBar.addAction((IAction)action);
        return action;
    }

    private Action createButtonRemoveReference(EditorToolBar toolBar) {
        Action action = new Action("Delete", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/remove.gif", "16x16")){
            {
                this.setToolTipText("Remove the reference chromatogram.");
            }

            public void runWithEvent(Event event) {
                ToolItem item = (ToolItem)event.widget;
                int index = ChromatogramReferencesUI.this.comboChromatograms.currentIndex();
                if (index > 0 && ChromatogramReferencesUI.this.comboChromatograms.master != null && MessageDialog.openQuestion((Shell)item.getParent().getShell(), (String)"Delete Reference", (String)("Do you want to delete the chromatogram reference: " + index))) {
                    IChromatogram chromatogram = ChromatogramReferencesUI.this.comboChromatograms.master.getChromatogram();
                    IChromatogramSelection remove = (IChromatogramSelection)ChromatogramReferencesUI.this.comboChromatograms.data.remove(index);
                    chromatogram.removeReferencedChromatogram(remove.getChromatogram());
                    ChromatogramReferencesUI.this.comboChromatograms.selection = (IStructuredSelection)new StructuredSelection((Object)ChromatogramReferencesUI.this.comboChromatograms.master);
                    ChromatogramReferencesUI.this.comboChromatograms.refreshUI();
                }
            }
        };
        toolBar.addAction((IAction)action);
        return action;
    }

    private Action createButtonAddReference(EditorToolBar toolBar) {
        Action action = new Action("Add", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16")){
            {
                this.setToolTipText("Add a reference chromatogram.");
            }

            public void runWithEvent(Event event) {
                IChromatogramSelection masterSelection;
                IChromatogramSelection chromatogramSelection;
                ToolItem item = (ToolItem)event.widget;
                ChromatogramEditorDialog dialog = new ChromatogramEditorDialog(item.getParent().getShell());
                if (dialog.open() == 0 && (chromatogramSelection = dialog.getChromatogramSelection()) != null && (masterSelection = ChromatogramReferencesUI.this.comboChromatograms.master) != null) {
                    if (masterSelection.getChromatogram() != chromatogramSelection.getChromatogram()) {
                        masterSelection.getChromatogram().addReferencedChromatogram(chromatogramSelection.getChromatogram());
                        ChromatogramReferencesUI.this.comboChromatograms.data.add(chromatogramSelection);
                        ChromatogramReferencesUI.this.comboChromatograms.selection = (IStructuredSelection)new StructuredSelection((Object)chromatogramSelection);
                        ChromatogramReferencesUI.this.comboChromatograms.refreshUI();
                        ChromatogramReferencesUI.this.updateButtons();
                    } else {
                        MessageDialog.openWarning((Shell)item.getParent().getShell(), (String)"Add Reference", (String)"You can't add the selected chromatogram as a reference.");
                    }
                }
            }
        };
        toolBar.addAction((IAction)action);
        return action;
    }

    private Action createButtonTargetTransfer(EditorToolBar toolBar) {
        Action action = new Action("Transfer", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/targets.gif", "16x16")){
            {
                this.setToolTipText("Transfer the peak targets.");
            }

            public void runWithEvent(Event event) {
                ToolItem item = (ToolItem)event.widget;
                IChromatogramSelection chromatogramSelection = (IChromatogramSelection)ChromatogramReferencesUI.this.comboChromatograms.selection.getFirstElement();
                if (chromatogramSelection != null) {
                    TargetTransferDialog dialog = new TargetTransferDialog(item.getParent().getShell(), chromatogramSelection);
                    dialog.open();
                } else {
                    MessageDialog.openWarning((Shell)item.getParent().getShell(), (String)"Peak Target Transfer", (String)"Please select a source chromatogram.");
                }
            }
        };
        toolBar.addAction((IAction)action);
        return action;
    }

    private void updateButtons() {
        int size = this.comboChromatograms.data.size();
        int selectionIndex = this.comboChromatograms.currentIndex();
        this.buttonPrevious.setEnabled(selectionIndex > 0);
        this.buttonNext.setEnabled(selectionIndex < size - 1);
        this.buttonRemove.setEnabled(selectionIndex > 0);
        this.buttonAdd.setEnabled(selectionIndex == 0);
        this.buttonTargetTransfer.setEnabled(size > 1);
    }

    public void update() {
        ArrayList<Object> chromatogramMasterAndReferences = new ArrayList<Object>();
        if (this.comboChromatograms.master != null) {
            IChromatogramSelection masterSelection = this.comboChromatograms.master;
            chromatogramMasterAndReferences.add(masterSelection);
            List referencedChromatograms = masterSelection.getChromatogram().getReferencedChromatograms();
            for (IChromatogram referencedChromatogram : referencedChromatograms) {
                ChromatogramSelectionCSD referenceSelection;
                if (referencedChromatogram instanceof IChromatogramCSD) {
                    referenceSelection = new ChromatogramSelectionCSD((IChromatogramCSD)referencedChromatogram);
                } else if (referencedChromatogram instanceof IChromatogramMSD) {
                    referenceSelection = new ChromatogramSelectionMSD((IChromatogramMSD)referencedChromatogram);
                } else {
                    if (!(referencedChromatogram instanceof IChromatogramWSD)) continue;
                    referenceSelection = new ChromatogramSelectionWSD((IChromatogramWSD)referencedChromatogram);
                }
                chromatogramMasterAndReferences.add(referenceSelection);
                referenceSelection.setRangeRetentionTime(masterSelection.getStartRetentionTime(), masterSelection.getStopRetentionTime());
            }
        }
        this.comboChromatograms.setInput(chromatogramMasterAndReferences);
    }

    private static final class ComboContainer
    implements ISelectionChangedListener {
        private IChromatogramSelection<?, ?> master;
        private IStructuredSelection selection = StructuredSelection.EMPTY;
        private List<IChromatogramSelection<?, ?>> data = Collections.emptyList();
        private final AtomicReference<ComboViewer> viewerReferenece = new AtomicReference();
        private final Consumer<IChromatogramSelection<?, ?>> listener;

        public ComboContainer(Consumer<IChromatogramSelection<?, ?>> chromatogramReferencesListener) {
            this.listener = chromatogramReferencesListener;
        }

        private void selectChromatogram(int index) {
            if (index < 0) {
                index = 0;
            } else if (index >= this.data.size()) {
                index = this.data.size() - 1;
            }
            this.setSelection((IStructuredSelection)new StructuredSelection(this.data.get(index)));
        }

        private int currentIndex() {
            return this.indexOf((IChromatogramSelection)this.selection.getFirstElement());
        }

        public int indexOf(IChromatogramSelection<?, ?> chromatogramSelection) {
            if (this.data != null) {
                return this.data.indexOf(chromatogramSelection);
            }
            return -1;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selection = (IStructuredSelection)event.getSelection();
            this.listener.accept((IChromatogramSelection)this.selection.getFirstElement());
        }

        private void setSelection(IStructuredSelection selection) {
            ComboViewer viewer = this.viewerReferenece.get();
            if (viewer != null) {
                viewer.setSelection((ISelection)selection);
            }
            this.selection = selection;
        }

        private void refreshUI() {
            this.setInput(this.data);
            this.setSelection(this.selection);
            ComboViewer viewer = this.viewerReferenece.get();
            if (viewer != null) {
                viewer.refresh();
            }
        }

        private void setInput(List<IChromatogramSelection<?, ?>> data) {
            this.data = data;
            ComboViewer viewer = this.viewerReferenece.get();
            if (viewer != null) {
                viewer.setInput((Object)(data != null ? data : Collections.EMPTY_LIST));
                Control control = viewer.getControl();
                if (!control.isDisposed()) {
                    control.setEnabled(data.size() > 1);
                }
            }
        }
    }
}

