/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.support.ui.provider.AbstractLabelProvider;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ChromatogramSourceCombo
extends Composite {
    private static final String SOURCE_REFERENCES = "Internal (This Chromatogram)";
    private static final String SOURCE_EDITORS = "External (Editor Chromatogram)";
    private List<String> sources = new ArrayList<String>();
    private ComboViewer comboViewer;

    public ChromatogramSourceCombo(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public boolean isSourceReferences() {
        return SOURCE_REFERENCES.equals(this.comboViewer.getCombo().getText());
    }

    public boolean isSourceEditors() {
        return SOURCE_EDITORS.equals(this.comboViewer.getCombo().getText());
    }

    public Combo getCombo() {
        return this.comboViewer.getCombo();
    }

    private void initialize() {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.comboViewer = this.createComboViewer(composite);
    }

    private ComboViewer createComboViewer(Composite parent) {
        ComboViewer comboViewer = new ComboViewer(parent, 8);
        Combo combo = comboViewer.getCombo();
        comboViewer.setContentProvider((IContentProvider)new ListContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new AbstractLabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                return null;
            }
        });
        combo.setToolTipText("Select the chromatogram destination.");
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        combo.setLayoutData((Object)gridData);
        this.sources.add(SOURCE_REFERENCES);
        this.sources.add(SOURCE_EDITORS);
        comboViewer.setInput(this.sources);
        return comboViewer;
    }
}

