/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ChromatogramScanInfoLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ChromtogramScanInfoContentProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.ChromtogramScanInfoTableComparator;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class ChromtogramScanInfoUI
extends ExtendedTableViewer {
    private String[] titles = new String[]{"Scan#", "RT (Minutes)", "Number Of Ions", "SIM/SCAN", "m/z..."};
    private int[] bounds = new int[]{120, 120, 120, 120, 120};

    public ChromtogramScanInfoUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection) {
        if (chromatogramSelection != null) {
            this.setInput(chromatogramSelection);
        } else {
            this.setInput(null);
        }
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider((IBaseLabelProvider)new ChromatogramScanInfoLabelProvider());
        this.setContentProvider((IContentProvider)new ChromtogramScanInfoContentProvider());
        this.setComparator((ViewerComparator)new ChromtogramScanInfoTableComparator());
        this.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = ChromtogramScanInfoUI.this.getStructuredSelection();
                Object object = structuredSelection.getFirstElement();
                if (object instanceof IScanMSD) {
                    IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                    eventBroker.send("scan/xxd/update/selection", object);
                }
            }
        });
    }
}

