/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.text.DecimalFormat;
import java.util.Iterator;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakDataSupport;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class ExtendedPeakDetailsUI {
    private Composite toolbarInfo;
    private Label labelPeak;
    private List list;
    private Clipboard clipboard;
    private DecimalFormat decimalFormat;
    private StringBuilder stringBuilder;
    private IPeak peak;
    private PeakDataSupport peakDataSupport = new PeakDataSupport();

    @Inject
    public ExtendedPeakDetailsUI(Composite parent) {
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
        this.stringBuilder = new StringBuilder();
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updatePeak();
    }

    public void update(IPeak peak) {
        this.peak = peak;
        this.labelPeak.setText(this.peakDataSupport.getPeakLabel(peak));
        this.updatePeak();
    }

    private void updatePeak() {
        if (this.peak != null) {
            this.setPeakValues(this.peak);
        } else {
            this.list.removeAll();
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.createPeakList(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createButtonToggleToolbarInfo(composite);
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelPeak = new Label(composite, 0);
        this.labelPeak.setText("");
        this.labelPeak.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakDetailsUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createPeakList(Composite parent) {
        this.clipboard = new Clipboard(DisplayUtils.getDisplay());
        this.list = new List(parent, 2818);
        this.list.setLayoutData((Object)new GridData(1808));
        this.list.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    StringBuilder builder = new StringBuilder();
                    String[] stringArray = ExtendedPeakDetailsUI.this.list.getSelection();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String selection = stringArray[n2];
                        builder.append(selection);
                        builder.append("\n");
                        ++n2;
                    }
                    if (builder.length() == 0) {
                        builder.append("Please select one or more entries in the list.\n");
                    }
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    Object[] data = new Object[]{builder.toString()};
                    Transfer[] dataTypes = new Transfer[]{textTransfer};
                    ExtendedPeakDetailsUI.this.clipboard.setContents(data, dataTypes);
                }
            }
        });
    }

    private void setPeakValues(IPeak peak) {
        this.list.removeAll();
        IPeakModel peakModel = peak.getPeakModel();
        this.list.add("PeakType: " + peak.getPeakType());
        LinearEquation equation = peakModel.getIncreasingInflectionPointEquation();
        this.list.add(this.getEquationString("Increasing Inflection Point Equation: ", equation));
        equation = peakModel.getDecreasingInflectionPointEquation();
        this.list.add(this.getEquationString("Decreasing Inflection Point Equation: ", equation));
        equation = peakModel.getPercentageHeightBaselineEquation(0.5f);
        this.list.add(this.getEquationString("Percentage Baseline Equation 50%: ", equation));
        this.list.add("Gradient Angle: " + this.decimalFormat.format(peakModel.getGradientAngle()));
        this.list.add("-------------------------");
        this.addRetentionTimes(peakModel);
    }

    private void addRetentionTimes(IPeakModel peakModel) {
        this.list.add("milliseconds  -  abundance  -  background  -  minutes");
        Iterator iterator = peakModel.getRetentionTimes().iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            double minutes = (double)retentionTime / 60000.0;
            float abundance = peakModel.getPeakAbundance(retentionTime);
            float background = peakModel.getBackgroundAbundance(retentionTime);
            this.clearStringBuilder();
            this.stringBuilder.append(this.decimalFormat.format(retentionTime));
            this.stringBuilder.append(" - ");
            this.stringBuilder.append(this.decimalFormat.format(abundance));
            this.stringBuilder.append(" - ");
            this.stringBuilder.append(this.decimalFormat.format(background));
            this.stringBuilder.append(" - ");
            this.stringBuilder.append(this.decimalFormat.format(minutes));
            this.list.add(this.stringBuilder.toString());
        }
    }

    private String getEquationString(String description, LinearEquation equation) {
        this.clearStringBuilder();
        this.stringBuilder.append(description);
        double b = equation.getB();
        this.stringBuilder.append("f(x)=");
        this.stringBuilder.append(this.decimalFormat.format(equation.getA()));
        if (b < 0.0) {
            this.stringBuilder.append("x");
        } else {
            this.stringBuilder.append("x+");
        }
        this.stringBuilder.append(this.decimalFormat.format(equation.getB()));
        return this.stringBuilder.toString();
    }

    private void clearStringBuilder() {
        this.stringBuilder.delete(0, this.stringBuilder.length());
    }
}

