/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.Activator;
import org.eclipse.chemclipse.ux.extension.xxd.ui.charts.ChromatogramChart;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.listener.BoxSelectionPaintListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.support.ManualPeakDetector;
import org.eclipse.chemclipse.ux.extension.xxd.ui.preferences.PreferencePagePeaks;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.BaselineSelectionPaintListener;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramChartSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.ChromatogramDataSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.support.charts.PeakChartSupport;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesData;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.linecharts.LineChart;

public class ExtendedPeakDetectorUI {
    private static final Logger logger = Logger.getLogger(ExtendedPeakDetectorUI.class);
    private static final String ID_PEAK = "Peak";
    private static final String ID_BACKGROUND = "Background";
    private static final String DETECTION_TYPE_BASELINE = "DETECTION_TYPE_BASELINE";
    private static final String DETECTION_TYPE_BOX = "DETECTION_TYPE_BOX";
    private static final String DETECTION_TYPE_BOX_BB = "DETECTION_TYPE_BOX_BB";
    private static final String DETECTION_TYPE_BOX_VV = "DETECTION_TYPE_BOX_VV";
    private static final String DETECTION_TYPE_BOX_BV = "DETECTION_TYPE_BOX_BV";
    private static final String DETECTION_TYPE_BOX_VB = "DETECTION_TYPE_BOX_VB";
    private static final String DETECTION_TYPE_NONE = "";
    private Map<String, String> detectionTypeDescriptions;
    private static final char KEY_BASELINE = 'd';
    private static final char KEY_BB = 'b';
    private static final char KEY_VV = 'v';
    private static final char KEY_BV = 'n';
    private static final char KEY_VB = 'c';
    private static final String DETECTION_BOX_LEFT = "DETECTION_BOX_LEFT";
    private static final String DETECTION_BOX_RIGHT = "DETECTION_BOX_RIGHT";
    private static final String DETECTION_BOX_NONE = "DETECTION_BOX_NONE";
    private static final int BOX_SNAP_MARKER_WINDOW = 4;
    private static final int BOX_MAX_DELTA = 1;
    private static final int STATUS_DETECTION_HINT_NONE = -1;
    private static final int STATUS_DETECTION_HINT_INACTIVE = 0;
    private static final int STATUS_DETECTION_HINT_ACTIVE = 1;
    private static final String MESSAGE_DETECTION_MODUS = "CTRL";
    private Composite toolbarInfo;
    private Label labelChromatogram;
    private Label labelDetectionType;
    private Label labelDetectionModus;
    private Button buttonDetectionTypeBaseline;
    private Button buttonDetectionTypeBoxBB;
    private Button buttonDetectionTypeBoxVV;
    private Button buttonDetectionTypeBoxBV;
    private Button buttonDetectionTypeBoxVB;
    private Button buttonAddPeak;
    private ChromatogramChart chromatogramChart;
    private IChromatogramSelection chromatogramSelection;
    private IPeak peak;
    private BaselineSelectionPaintListener baselineSelectionPaintListener;
    private BoxSelectionPaintListener boxSelectionPaintListener;
    private Cursor defaultCursor;
    private String detectionType = "";
    private String detectionBox = "DETECTION_BOX_NONE";
    private int xStart;
    private int yStart;
    private int xStop;
    private int yStop;
    private int xBoxMoveStart;
    private ChromatogramDataSupport chromatogramDataSupport = new ChromatogramDataSupport();
    private ChromatogramChartSupport chromatogramChartSupport = new ChromatogramChartSupport();
    private PeakChartSupport peakChartSupport = new PeakChartSupport();

    @Inject
    public ExtendedPeakDetectorUI(Composite parent) {
        this.detectionTypeDescriptions = new HashMap<String, String>();
        this.detectionTypeDescriptions.put(DETECTION_TYPE_BASELINE, "Modus (Baseline) [Key:d]");
        this.detectionTypeDescriptions.put(DETECTION_TYPE_BOX_BB, "Modus (BB) [Key:b]");
        this.detectionTypeDescriptions.put(DETECTION_TYPE_BOX_VV, "Modus (VV) [Key:v]");
        this.detectionTypeDescriptions.put(DETECTION_TYPE_BOX_BV, "Modus (BV) [Key:n]");
        this.detectionTypeDescriptions.put(DETECTION_TYPE_BOX_VB, "Modus (VB) [Key:c]");
        this.detectionTypeDescriptions.put(DETECTION_TYPE_NONE, DETECTION_TYPE_NONE);
        this.initialize(parent);
    }

    @Focus
    public void setFocus() {
        this.updateChromatogramAndPeak();
    }

    public void update(IChromatogramSelection chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
        IChromatogram chromatogram = null;
        if (chromatogramSelection != null) {
            chromatogram = chromatogramSelection.getChromatogram();
        }
        this.setDetectionType(DETECTION_TYPE_NONE);
        this.labelChromatogram.setText(ChromatogramDataSupport.getChromatogramLabel(chromatogram));
        this.peak = null;
        this.updateChromatogramAndPeak();
    }

    private void updateChromatogramAndPeak() {
        this.chromatogramChart.deleteSeries();
        this.buttonAddPeak.setEnabled(false);
        this.enableButtons(DETECTION_TYPE_NONE);
        if (this.chromatogramSelection != null) {
            IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
            ArrayList<ILineSeriesData> lineSeriesDataList = new ArrayList<ILineSeriesData>();
            Color colorChromatogram = Colors.getColor((String)preferenceStore.getString("colorPeakDetectorChromatogram"));
            boolean enableAreaChromatogram = preferenceStore.getBoolean("showPeakDetectorChromatogramArea");
            int scanMarkerSize = preferenceStore.getInt("showPeakDetectorScanMarkerSize");
            Color scanMarkerColor = Colors.getColor((String)preferenceStore.getString("showPeakDetectorScanMarkerColor"));
            ILineSeries.PlotSymbolType scanMarkerSymbol = ILineSeries.PlotSymbolType.valueOf((String)preferenceStore.getString("showPeakDetectorScanMarkerType"));
            ILineSeriesData lineSeriesData = this.chromatogramChartSupport.getLineSeriesDataChromatogram(this.chromatogramSelection, "Chromatogram", colorChromatogram);
            ILineSeriesSettings lineSeriesSettings = lineSeriesData.getSettings();
            lineSeriesSettings.setEnableArea(enableAreaChromatogram);
            lineSeriesSettings.setSymbolSize(scanMarkerSize);
            lineSeriesSettings.setSymbolColor(scanMarkerColor);
            lineSeriesSettings.setSymbolType(scanMarkerSymbol);
            lineSeriesDataList.add(lineSeriesData);
            if (this.peak != null) {
                this.buttonAddPeak.setEnabled(true);
                boolean includeBackground = true;
                boolean mirrored = false;
                Color colorPeak = Colors.getColor((String)preferenceStore.getString("colorPeak1"));
                lineSeriesDataList.add(this.peakChartSupport.getPeak(this.peak, includeBackground, mirrored, colorPeak, ID_PEAK));
                if (includeBackground) {
                    Color colorBackground = Colors.getColor((String)preferenceStore.getString("colorPeakBackground"));
                    lineSeriesDataList.add(this.peakChartSupport.getPeakBackground(this.peak, mirrored, colorBackground, ID_BACKGROUND));
                }
            }
            this.chromatogramChart.addSeriesData(lineSeriesDataList, LineChart.LOW_COMPRESSION);
        }
    }

    private void initialize(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.createToolbarMain(parent);
        this.toolbarInfo = this.createToolbarInfo(parent);
        this.createChromatogramChart(parent);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(12, false));
        this.labelDetectionType = this.createDetectionTypeLabel(composite);
        this.labelDetectionModus = this.createDetectionModusLabel(composite);
        this.createButtonToggleToolbarInfo(composite);
        this.buttonDetectionTypeBaseline = this.createDetectionTypeButton(composite, DETECTION_TYPE_BASELINE, "org.eclipse.chemclipse.rcp.ui.icons/detectionTypeBaseline.gif");
        this.buttonDetectionTypeBoxBB = this.createDetectionTypeButton(composite, DETECTION_TYPE_BOX_BB, "org.eclipse.chemclipse.rcp.ui.icons/detectionTypeScanBB.gif");
        this.buttonDetectionTypeBoxVV = this.createDetectionTypeButton(composite, DETECTION_TYPE_BOX_VV, "org.eclipse.chemclipse.rcp.ui.icons/detectionTypeScanVV.gif");
        this.buttonDetectionTypeBoxBV = this.createDetectionTypeButton(composite, DETECTION_TYPE_BOX_BV, "org.eclipse.chemclipse.rcp.ui.icons/detectionTypeScanBV.gif");
        this.buttonDetectionTypeBoxVB = this.createDetectionTypeButton(composite, DETECTION_TYPE_BOX_VB, "org.eclipse.chemclipse.rcp.ui.icons/detectionTypeScanVB.gif");
        this.buttonAddPeak = this.createAddPeakButton(composite);
        this.createToggleChartLegendButton(composite);
        this.createDetectionTypeButton(composite, DETECTION_TYPE_NONE, "org.eclipse.chemclipse.rcp.ui.icons/reset.gif");
        this.createSettingsButton(composite);
    }

    private Label createDetectionTypeLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(DETECTION_TYPE_NONE);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Label createDetectionModusLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MESSAGE_DETECTION_MODUS);
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.labelChromatogram = new Label(composite, 0);
        this.labelChromatogram.setText(DETECTION_TYPE_NONE);
        this.labelChromatogram.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Button createDetectionTypeButton(Composite parent, final String detectionType, String image) {
        Button button = new Button(parent, 8);
        button.setText(DETECTION_TYPE_NONE);
        button.setToolTipText(this.detectionTypeDescriptions.get(detectionType));
        button.setImage(ApplicationImageFactory.getInstance().getImage(image, "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakDetectorUI.this.setDetectionType(detectionType);
                if (detectionType.equals(ExtendedPeakDetectorUI.DETECTION_TYPE_NONE)) {
                    ExtendedPeakDetectorUI.this.reset();
                }
            }
        });
        return button;
    }

    private Button createAddPeakButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(DETECTION_TYPE_NONE);
        button.setToolTipText("Add the manually detected peak.");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ExtendedPeakDetectorUI.this.peak != null) {
                    IChromatogram chromatogram = ExtendedPeakDetectorUI.this.chromatogramSelection.getChromatogram();
                    if (chromatogram instanceof IChromatogramMSD) {
                        if (ExtendedPeakDetectorUI.this.peak instanceof IChromatogramPeakMSD) {
                            IChromatogramPeakMSD peakMSD = (IChromatogramPeakMSD)ExtendedPeakDetectorUI.this.peak;
                            ((IChromatogramMSD)chromatogram).addPeak((IPeak)peakMSD);
                            ExtendedPeakDetectorUI.this.peak = null;
                            ExtendedPeakDetectorUI.this.setDetectionType(ExtendedPeakDetectorUI.DETECTION_TYPE_NONE);
                            ExtendedPeakDetectorUI.this.updateChromatogramAndPeak();
                            ExtendedPeakDetectorUI.this.chromatogramSelection.update(true);
                        }
                    } else if (chromatogram instanceof IChromatogramCSD && ExtendedPeakDetectorUI.this.peak instanceof IChromatogramPeakCSD) {
                        IChromatogramPeakCSD peakCSD = (IChromatogramPeakCSD)ExtendedPeakDetectorUI.this.peak;
                        ((IChromatogramCSD)chromatogram).addPeak((IPeak)peakCSD);
                        ExtendedPeakDetectorUI.this.peak = null;
                        ExtendedPeakDetectorUI.this.setDetectionType(ExtendedPeakDetectorUI.DETECTION_TYPE_NONE);
                        ExtendedPeakDetectorUI.this.updateChromatogramAndPeak();
                        ExtendedPeakDetectorUI.this.chromatogramSelection.update(true);
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText(DETECTION_TYPE_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)ExtendedPeakDetectorUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private void createToggleChartLegendButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Toggle the chart legend");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/tag.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtendedPeakDetectorUI.this.chromatogramChart.toggleSeriesLegendVisibility();
            }
        });
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText(DETECTION_TYPE_NONE);
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePagePeaks preferencePage = new PreferencePagePeaks();
                preferencePage.setTitle("Peak Settings");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePage));
                PreferenceDialog preferenceDialog = new PreferenceDialog(e.display.getActiveShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        ExtendedPeakDetectorUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)e.display.getActiveShell(), (String)"Settings", (String)"Something has gone wrong to apply the chart settings.");
                    }
                }
            }
        });
    }

    private void createChromatogramChart(Composite parent) {
        this.chromatogramChart = new ChromatogramChart(parent, 2048);
        this.chromatogramChart.setLayoutData(new GridData(1808));
        this.defaultCursor = this.chromatogramChart.getBaseChart().getCursor();
        IChartSettings chartSettings = this.chromatogramChart.getChartSettings();
        chartSettings.setCreateMenu(true);
        chartSettings.setEnableRangeSelector(true);
        chartSettings.setShowRangeSelectorInitially(false);
        chartSettings.setSupportDataShift(false);
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(100));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(98));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(118));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(110));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(99));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(0x1000003));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new KeyPressedEventProcessor(0x1000004));
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new MouseDownEventProcessor());
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new MouseMoveEventProcessor());
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new MouseUpEventProcessor());
        chartSettings.addHandledEventProcessor((IHandledEventProcessor)new MouseDoubleClickEventProcessor());
        this.chromatogramChart.applySettings(chartSettings);
        IPlotArea plotArea = this.getPlotArea();
        this.baselineSelectionPaintListener = new BaselineSelectionPaintListener();
        this.boxSelectionPaintListener = new BoxSelectionPaintListener();
        plotArea.addCustomPaintListener((ICustomPaintListener)this.baselineSelectionPaintListener);
        plotArea.addCustomPaintListener((ICustomPaintListener)this.boxSelectionPaintListener);
    }

    private void setDetectionType(String detectionType) {
        this.detectionType = detectionType;
        if (detectionType.equals(DETECTION_TYPE_NONE)) {
            this.setDetectionModusLabel(-1);
            this.setCursorDefault();
            this.resetSelectedRange();
        } else if (detectionType.startsWith(DETECTION_TYPE_BOX)) {
            this.setDetectionModusLabel(-1);
        } else {
            this.setDetectionModusLabel(0);
        }
        if (detectionType.equals(DETECTION_TYPE_NONE) || detectionType.equals(DETECTION_TYPE_BASELINE)) {
            this.detectionBox = DETECTION_BOX_NONE;
        }
        this.enableButtons(detectionType);
        if (!detectionType.equals(DETECTION_TYPE_BOX)) {
            this.labelDetectionType.setText(this.detectionTypeDescriptions.get(detectionType));
        }
    }

    private void enableButtons(String detectionType) {
        boolean enabled = detectionType.equals(DETECTION_TYPE_NONE);
        this.buttonDetectionTypeBaseline.setEnabled(enabled);
        this.buttonDetectionTypeBoxBB.setEnabled(enabled);
        this.buttonDetectionTypeBoxVV.setEnabled(enabled);
        this.buttonDetectionTypeBoxBV.setEnabled(enabled);
        this.buttonDetectionTypeBoxVB.setEnabled(enabled);
    }

    private void resetSelectedRange() {
        this.baselineSelectionPaintListener.reset();
        this.boxSelectionPaintListener.reset();
        this.xStart = 0;
        this.yStart = 0;
        this.xStop = 0;
        this.yStop = 0;
        this.xBoxMoveStart = 0;
    }

    private void handleKeyPressedEvent(Event event) {
        if (this.detectionType.equals(DETECTION_TYPE_NONE)) {
            if (event.keyCode == 100) {
                this.setDetectionType(DETECTION_TYPE_BASELINE);
            } else if (event.keyCode == 98) {
                this.setDetectionType(DETECTION_TYPE_BOX_BB);
            } else if (event.keyCode == 118) {
                this.setDetectionType(DETECTION_TYPE_BOX_VV);
            } else if (event.keyCode == 110) {
                this.setDetectionType(DETECTION_TYPE_BOX_BV);
            } else if (event.keyCode == 99) {
                this.setDetectionType(DETECTION_TYPE_BOX_VB);
            }
        } else if (this.detectionType.startsWith(DETECTION_TYPE_BOX)) {
            if (event.keyCode == 0x1000003) {
                if (this.detectionBox.equals(DETECTION_BOX_LEFT)) {
                    --this.xStart;
                    this.redrawBoxPeakSelection(true);
                } else if (this.detectionBox.equals(DETECTION_BOX_RIGHT)) {
                    --this.xStop;
                    this.redrawBoxPeakSelection(true);
                }
            } else if (event.keyCode == 0x1000004) {
                if (this.detectionBox.equals(DETECTION_BOX_LEFT)) {
                    ++this.xStart;
                    this.redrawBoxPeakSelection(true);
                } else if (this.detectionBox.equals(DETECTION_BOX_RIGHT)) {
                    ++this.xStop;
                    this.redrawBoxPeakSelection(true);
                }
            }
        }
    }

    private void handleMouseDownEvent(Event event) {
        if (this.detectionType.equals(DETECTION_TYPE_BASELINE)) {
            this.setDetectionModusLabel(1);
            this.startBaselineSelection(event.x, event.y);
            this.setCursor(2);
        } else if (this.detectionType.startsWith(DETECTION_TYPE_BOX)) {
            this.setDetectionModusLabel(1);
            if (this.isLeftMoveSnapMarker(event.x)) {
                this.setCursor(9);
                this.xBoxMoveStart = event.x;
                this.detectionBox = DETECTION_BOX_LEFT;
            } else if (this.isRightMoveSnapMarker(event.x)) {
                this.setCursor(9);
                this.xBoxMoveStart = event.x;
                this.detectionBox = DETECTION_BOX_RIGHT;
            } else {
                this.setCursor(2);
                this.detectionBox = DETECTION_BOX_NONE;
            }
        } else {
            this.setDetectionModusLabel(-1);
        }
    }

    private void handleMouseMoveEvent(Event event) {
        if (this.detectionType.equals(DETECTION_TYPE_BASELINE)) {
            if (this.isControlKeyPressed(event) && this.xStart > 0 && this.yStart > 0) {
                this.trackBaselineSelection(event.x, event.y);
            }
        } else if (this.detectionType.startsWith(DETECTION_TYPE_BOX)) {
            if (this.isLeftMoveSnapMarker(event.x)) {
                this.setCursor(9);
            } else if (this.isRightMoveSnapMarker(event.x)) {
                this.setCursor(9);
            } else {
                this.setCursor(2);
            }
            if (this.isLeftMouseButtonPressed(event) && !this.detectionBox.equals(DETECTION_BOX_NONE)) {
                int delta = this.getDeltaMove(event.x);
                if (this.detectionBox.equals(DETECTION_BOX_LEFT)) {
                    this.xStart += delta;
                    this.redrawBoxPeakSelection(false);
                } else if (this.detectionBox.equals(DETECTION_BOX_RIGHT)) {
                    this.xStop += delta;
                    this.redrawBoxPeakSelection(false);
                }
            }
        }
    }

    private void handleMouseUpEvent(Event event) {
        if (this.detectionType.equals(DETECTION_TYPE_BASELINE)) {
            if (this.isControlKeyPressed(event)) {
                this.stopBaselineSelection(event.x, event.y);
                this.setCursorDefault();
            }
        } else if (this.detectionType.startsWith(DETECTION_TYPE_BOX)) {
            if (event.button == 1) {
                this.setCursor(2);
                if (!this.detectionBox.equals(DETECTION_BOX_NONE)) {
                    int delta = this.getDeltaMove(event.x);
                    if (this.detectionBox.equals(DETECTION_BOX_LEFT)) {
                        this.xStart += delta;
                        this.redrawBoxPeakSelection(true);
                    } else if (this.detectionBox.equals(DETECTION_BOX_RIGHT)) {
                        this.xStop += delta;
                        this.redrawBoxPeakSelection(true);
                    }
                }
                if (event.count == 1) {
                    this.detectionBox = this.getDetectionBox(event.x);
                    this.redrawBoxPeakSelection(false);
                }
            }
        } else {
            this.setDetectionModusLabel(-1);
        }
    }

    private boolean isControlKeyPressed(Event event) {
        return (event.stateMask & 0x40000) == 262144;
    }

    private boolean isLeftMouseButtonPressed(Event event) {
        return (event.stateMask & 0x80000) == 524288;
    }

    private void handleMouseDoubleClickEvent(Event event) {
        block35: {
            block32: {
                block36: {
                    int y;
                    block33: {
                        int y2;
                        if (!this.detectionType.startsWith(DETECTION_TYPE_BOX)) break block32;
                        this.setDetectionModusLabel(0);
                        this.setCursor(2);
                        if (this.xStart != 0) break block33;
                        switch (this.detectionType) {
                            case "DETECTION_TYPE_BOX_BB": {
                                y2 = this.getPlotArea().getBounds().height;
                                break;
                            }
                            case "DETECTION_TYPE_BOX_VV": {
                                y2 = event.y;
                                break;
                            }
                            case "DETECTION_TYPE_BOX_BV": {
                                y2 = this.getPlotArea().getBounds().height;
                                break;
                            }
                            case "DETECTION_TYPE_BOX_VB": {
                                y2 = event.y;
                                break;
                            }
                            default: {
                                y2 = this.getPlotArea().getBounds().height;
                            }
                        }
                        this.startBoxPeakSelection(event.x, y2);
                        break block35;
                    }
                    if (this.xStart <= 0 || this.xStop != 0) break block36;
                    switch (this.detectionType) {
                        case "DETECTION_TYPE_BOX_BB": {
                            y = this.getPlotArea().getBounds().height;
                            break;
                        }
                        case "DETECTION_TYPE_BOX_VV": {
                            y = event.y;
                            break;
                        }
                        case "DETECTION_TYPE_BOX_BV": {
                            y = this.getPlotArea().getBounds().height;
                            break;
                        }
                        case "DETECTION_TYPE_BOX_VB": {
                            y = event.y;
                            break;
                        }
                        default: {
                            y = this.getPlotArea().getBounds().height;
                        }
                    }
                    this.stopBoxPeakSelection(event.x, y);
                    break block35;
                }
                this.setDetectionType(DETECTION_TYPE_NONE);
                break block35;
            }
            this.setDetectionModusLabel(-1);
        }
    }

    private IPlotArea getPlotArea() {
        return this.chromatogramChart.getBaseChart().getPlotArea();
    }

    private void applySettings() {
        this.updateChromatogramAndPeak();
    }

    private void redraw() {
        this.chromatogramChart.getBaseChart().redraw();
    }

    private void setCursor(int cursorId) {
        this.chromatogramChart.getBaseChart().setCursor(DisplayUtils.getDisplay().getSystemCursor(cursorId));
    }

    private void setCursorDefault() {
        this.chromatogramChart.getBaseChart().setCursor(this.defaultCursor);
    }

    private String getDetectionBox(int x) {
        if (this.xStart > 0) {
            if (x <= this.xStart) {
                return DETECTION_BOX_LEFT;
            }
            if (this.xStop > 0 && x >= this.xStop) {
                return DETECTION_BOX_RIGHT;
            }
        }
        return DETECTION_BOX_NONE;
    }

    private boolean isLeftMoveSnapMarker(int x) {
        return x > this.xStart - 4 && x < this.xStart + 4;
    }

    private boolean isRightMoveSnapMarker(int x) {
        return x > this.xStop - 4 && x < this.xStop + 4;
    }

    private int getDeltaMove(int x) {
        int delta = x - this.xBoxMoveStart;
        if (Math.abs(delta) > 1) {
            delta = delta < 0 ? -1 : 1;
        }
        return delta;
    }

    private void startBaselineSelection(int x, int y) {
        this.xStart = x;
        this.yStart = y;
        this.baselineSelectionPaintListener.setX1(this.xStart);
        this.baselineSelectionPaintListener.setY1(this.yStart);
    }

    private void trackBaselineSelection(int x, int y) {
        this.xStop = x;
        this.yStop = y;
        this.baselineSelectionPaintListener.setX1(this.xStart);
        this.baselineSelectionPaintListener.setY1(this.yStart);
        this.baselineSelectionPaintListener.setX2(this.xStop);
        this.baselineSelectionPaintListener.setY2(this.yStop);
        this.redraw();
    }

    private void stopBaselineSelection(int x, int y) {
        this.xStop = x;
        this.yStop = y;
        this.extractPeak(DETECTION_TYPE_NONE);
    }

    private void startBoxPeakSelection(int x, int y) {
        this.xStart = x;
        this.yStart = y;
        this.setCursor(2);
        this.boxSelectionPaintListener.setX1(this.xStart);
        this.boxSelectionPaintListener.setX2(this.xStop);
        this.redraw();
    }

    private void stopBoxPeakSelection(int x, int y) {
        if (x > this.xStart) {
            this.xStop = x;
            this.yStop = y;
            this.boxSelectionPaintListener.setX1(this.xStart);
            this.boxSelectionPaintListener.setX2(this.xStop);
            this.redraw();
            this.extractPeak(DETECTION_TYPE_BOX);
            this.enableButtons(DETECTION_TYPE_BOX);
        }
    }

    private void redrawBoxPeakSelection(boolean extractPeak) {
        this.boxSelectionPaintListener.setX1(this.xStart);
        this.boxSelectionPaintListener.setX2(this.xStop);
        if (this.detectionBox.equals(DETECTION_BOX_LEFT)) {
            this.boxSelectionPaintListener.setHighlightBox("HIGHLIGHT_BOX_LEFT");
        } else if (this.detectionBox.equals(DETECTION_BOX_RIGHT)) {
            this.boxSelectionPaintListener.setHighlightBox("HIGHLIGHT_BOX_RIGHT");
        } else {
            this.boxSelectionPaintListener.setHighlightBox("HIGHLIGHT_BOX_NONE");
        }
        this.redraw();
        if (extractPeak) {
            this.extractPeak(DETECTION_TYPE_BOX);
            this.enableButtons(DETECTION_TYPE_BOX);
        }
    }

    private void extractPeak(String detectionType) {
        this.peak = this.extractPeakFromUserSelection(this.xStart, this.yStart, this.xStop, this.yStop);
        IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
        eventBroker.send("peak/xxd/update/selection", (Object)this.peak);
        BaseChart baseChart = this.chromatogramChart.getBaseChart();
        IAxisSet axisSet = baseChart.getAxisSet();
        IAxis xAxis = axisSet.getXAxis(0);
        Range xRange = xAxis.getRange();
        IAxis yAxis = axisSet.getYAxis(0);
        Range yRange = yAxis.getRange();
        this.setDetectionType(detectionType);
        this.updateChromatogramAndPeak();
        xAxis.setRange(xRange);
        yAxis.setRange(yRange);
        this.redraw();
    }

    private IPeak extractPeakFromUserSelection(int xStart, int yStart, int xStop, int yStop) {
        IChromatogramPeakMSD peak = null;
        Rectangle rectangle = this.getPlotArea().getBounds();
        int height = rectangle.height;
        double factorHeight = 100.0 / (double)height;
        int width = rectangle.width;
        double factorWidth = 100.0 / (double)width;
        double percentageStartHeight = (100.0 - factorHeight * (double)yStart) / 100.0;
        double percentageStopHeight = (100.0 - factorHeight * (double)yStop) / 100.0;
        double percentageStartWidth = factorWidth * (double)xStart / 100.0;
        double percentageStopWidth = factorWidth * (double)xStop / 100.0;
        BaseChart baseChart = this.chromatogramChart.getBaseChart();
        IAxis retentionTime = baseChart.getAxisSet().getXAxis(0);
        Range millisecondsRange = retentionTime.getRange();
        IAxis intensity = baseChart.getAxisSet().getYAxis(0);
        Range abundanceRange = intensity.getRange();
        double abundanceHeight = abundanceRange.upper - abundanceRange.lower;
        double millisecondsWidth = millisecondsRange.upper - millisecondsRange.lower;
        int startRetentionTime = (int)(millisecondsRange.lower + millisecondsWidth * percentageStartWidth);
        int stopRetentionTime = (int)(millisecondsRange.lower + millisecondsWidth * percentageStopWidth);
        float startAbundance = (float)(abundanceRange.lower + abundanceHeight * percentageStartHeight);
        float stopAbundance = (float)(abundanceRange.lower + abundanceHeight * percentageStopHeight);
        if (this.chromatogramSelection instanceof IChromatogramSelectionMSD) {
            try {
                IChromatogramPeakMSD chromatogramPeak;
                IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)this.chromatogramSelection;
                ManualPeakDetector manualPeakDetector = new ManualPeakDetector();
                IChromatogramMSD chromatogram = chromatogramSelectionMSD.getChromatogramMSD();
                peak = chromatogramPeak = manualPeakDetector.calculatePeak(chromatogram, startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        } else if (this.chromatogramSelection instanceof IChromatogramSelectionCSD) {
            try {
                IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)this.chromatogramSelection;
                ManualPeakDetector manualPeakDetector = new ManualPeakDetector();
                IChromatogramCSD chromatogram = chromatogramSelectionCSD.getChromatogramCSD();
                IChromatogramPeakCSD chromatogramPeak = manualPeakDetector.calculatePeak(chromatogram, startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                peak = chromatogramPeak;
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        } else if (this.chromatogramSelection instanceof IChromatogramSelectionWSD) {
            try {
                IChromatogramSelectionWSD chromatogramSelectionWSD = (IChromatogramSelectionWSD)this.chromatogramSelection;
                ManualPeakDetector manualPeakDetector = new ManualPeakDetector();
                IChromatogramWSD chromatogram = chromatogramSelectionWSD.getChromatogramWSD();
                IChromatogramPeakWSD chromatogramPeak = manualPeakDetector.calculatePeak(chromatogram, startRetentionTime, stopRetentionTime, startAbundance, stopAbundance);
                peak = chromatogramPeak;
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
        }
        return peak;
    }

    private void reset() {
        this.peak = null;
        this.setDetectionType(DETECTION_TYPE_NONE);
        this.updateChromatogramAndPeak();
    }

    private void setDetectionModusLabel(int status) {
        switch (status) {
            case 0: {
                this.labelDetectionModus.setText(MESSAGE_DETECTION_MODUS);
                this.labelDetectionModus.setBackground(Colors.YELLOW);
                break;
            }
            case 1: {
                this.labelDetectionModus.setText(MESSAGE_DETECTION_MODUS);
                this.labelDetectionModus.setBackground(Colors.GREEN);
                break;
            }
            default: {
                this.labelDetectionModus.setText(DETECTION_TYPE_NONE);
                this.labelDetectionModus.setBackground(null);
            }
        }
    }

    private class KeyPressedEventProcessor
    extends AbstractHandledEventProcessor
    implements IHandledEventProcessor {
        private int keyCode;

        public KeyPressedEventProcessor(int keyCode) {
            this.keyCode = keyCode;
        }

        public int getEvent() {
            return 6;
        }

        public int getButton() {
            return this.keyCode;
        }

        public int getStateMask() {
            return 0;
        }

        public void handleEvent(BaseChart baseChart, Event event) {
            ExtendedPeakDetectorUI.this.handleKeyPressedEvent(event);
        }
    }

    private class MouseDoubleClickEventProcessor
    extends AbstractHandledEventProcessor
    implements IHandledEventProcessor {
        private MouseDoubleClickEventProcessor() {
        }

        public int getEvent() {
            return 1;
        }

        public int getButton() {
            return 1;
        }

        public int getStateMask() {
            return 0;
        }

        public void handleEvent(BaseChart baseChart, Event event) {
            ExtendedPeakDetectorUI.this.handleMouseDoubleClickEvent(event);
        }
    }

    private class MouseDownEventProcessor
    extends AbstractHandledEventProcessor
    implements IHandledEventProcessor {
        private MouseDownEventProcessor() {
        }

        public int getEvent() {
            return 3;
        }

        public int getButton() {
            return 1;
        }

        public int getStateMask() {
            return 262144;
        }

        public void handleEvent(BaseChart baseChart, Event event) {
            ExtendedPeakDetectorUI.this.handleMouseDownEvent(event);
        }
    }

    private class MouseMoveEventProcessor
    extends AbstractHandledEventProcessor
    implements IHandledEventProcessor {
        private MouseMoveEventProcessor() {
        }

        public int getEvent() {
            return 4;
        }

        public int getStateMask() {
            return 262144;
        }

        public void handleEvent(BaseChart baseChart, Event event) {
            ExtendedPeakDetectorUI.this.handleMouseMoveEvent(event);
        }
    }

    private class MouseUpEventProcessor
    extends AbstractHandledEventProcessor
    implements IHandledEventProcessor {
        private MouseUpEventProcessor() {
        }

        public int getEvent() {
            return 5;
        }

        public int getButton() {
            return 1;
        }

        public int getStateMask() {
            return 524288;
        }

        public void handleEvent(BaseChart baseChart, Event event) {
            ExtendedPeakDetectorUI.this.handleMouseUpEvent(event);
        }
    }
}

