/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.MassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.filter.AmbiguousPeakRemoverFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.filter.AreaComparator;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.filter.PeakGroup;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.amdis.filter.SNRComparator;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.filter.IPeakFilter;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.MatchConstraints;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.Processor;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.filter.CRUDListener;
import org.eclipse.chemclipse.processing.filter.Filter;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IPeakFilter.class, Filter.class, Processor.class})
public class AmbiguousPeakRemoverFilter
implements IPeakFilter<AmbiguousPeakRemoverFilterSettings> {
    private static final String NAME = "Ambiguous Peak Remover";

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "Filtering ambiguous peaks in a given retention window ";
    }

    public Class<AmbiguousPeakRemoverFilterSettings> getConfigClass() {
        return AmbiguousPeakRemoverFilterSettings.class;
    }

    public <X extends IPeak> void filterIPeaks(CRUDListener<X, IPeakModel> listener, AmbiguousPeakRemoverFilterSettings configuration, MessageConsumer messageConsumer, IProgressMonitor monitor) throws IllegalArgumentException {
        Comparator compareFunction;
        ArrayList peaks = new ArrayList(listener.read());
        if (configuration == null) {
            configuration = (AmbiguousPeakRemoverFilterSettings)this.createNewConfiguration();
        }
        if (configuration.getMethod() == AmbiguousPeakRemoverFilterSettings.SelectionMethod.AREA) {
            compareFunction = new AreaComparator();
            for (IPeak peak : peaks) {
                if (peak instanceof IPeakMSD) continue;
                throw new IllegalArgumentException("invalid peak type");
            }
        } else {
            compareFunction = new SNRComparator();
            for (IPeak peak : peaks) {
                if (!(peak instanceof IChromatogramPeakMSD)) {
                    messageConsumer.addWarnMessage(this.getName(), "SNR compare method is only avaiable for Chromatogram Peaks, skip processing");
                    return;
                }
                if (peak instanceof IPeakMSD) continue;
                throw new IllegalArgumentException("invalid peak type");
            }
        }
        AmbiguousPeakRemoverFilter.filterDuplicatePeaks(peaks, configuration, listener, compareFunction, monitor);
    }

    public boolean acceptsIPeaks(Collection<? extends IPeak> items) {
        for (IPeak iPeak : items) {
            IPeakMSD peakMSD = (IPeakMSD)Adapters.adapt((Object)iPeak, IPeakMSD.class);
            if (peakMSD != null) continue;
            return false;
        }
        return true;
    }

    public AmbiguousPeakRemoverFilterSettings createConfiguration(Collection<? extends IPeak> items) throws IllegalArgumentException {
        for (IPeak iPeak : items) {
            if (!(iPeak instanceof IChromatogramPeakMSD)) continue;
            return new AmbiguousPeakRemoverFilterSettings(((IChromatogramPeakMSD)iPeak).getChromatogram());
        }
        return (AmbiguousPeakRemoverFilterSettings)super.createConfiguration(items);
    }

    private static <X extends IPeak> void filterDuplicatePeaks(List<X> peaks, AmbiguousPeakRemoverFilterSettings settings, CRUDListener<? super X, ?> listener, Comparator<X> compareFunction, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NAME, (int)peaks.size());
        Collections.sort(peaks, new Comparator<X>(){

            @Override
            public int compare(X p1, X p2) {
                return AmbiguousPeakRemoverFilter.getRTDelta((IPeak)Adapters.adapt(p1, IPeakMSD.class), (IPeak)Adapters.adapt(p2, IPeakMSD.class));
            }
        });
        IPeak lastPeak = null;
        ArrayList<IPeak> candidatePeakSet = new ArrayList<IPeak>();
        IMassSpectrumComparator comparator = MassSpectrumComparator.getMassSpectrumComparator((String)settings.getComparatorID());
        for (IPeak peak : peaks) {
            if (lastPeak != null) {
                double deltaSeconds = (double)AmbiguousPeakRemoverFilter.getRTDelta(peak, lastPeak) / 1000.0;
                double deltaMinutes = deltaSeconds / 60.0;
                if (deltaMinutes < settings.getRtMaxdistance()) {
                    candidatePeakSet.add(peak);
                    lastPeak = peak;
                } else {
                    AmbiguousPeakRemoverFilter.deletePeaks(AmbiguousPeakRemoverFilter.extractPeaks(candidatePeakSet, comparator, settings.getMinmatchfactor()), listener, compareFunction);
                    lastPeak = null;
                }
            }
            if (lastPeak == null) {
                lastPeak = peak;
                candidatePeakSet.clear();
                candidatePeakSet.add(peak);
            }
            subMonitor.worked(1);
        }
        if (!candidatePeakSet.isEmpty()) {
            AmbiguousPeakRemoverFilter.deletePeaks(AmbiguousPeakRemoverFilter.extractPeaks(candidatePeakSet, comparator, settings.getMinmatchfactor()), listener, compareFunction);
        }
    }

    private static <T extends IPeak> List<PeakGroup<T>> extractPeaks(List<T> candidatePeakSet, IMassSpectrumComparator comparator, double minMatchFactor) {
        MatchConstraints matchConstraints = new MatchConstraints();
        int size = candidatePeakSet.size();
        if (size < 2) {
            return Collections.emptyList();
        }
        ArrayList<PeakGroup<T>> peakGroups = new ArrayList<PeakGroup<T>>();
        int i = 0;
        while (i < size) {
            IPeak candidate = (IPeak)candidatePeakSet.get(i);
            int j = 0;
            while (j < size) {
                float matchFactor;
                IComparisonResult result;
                IPeak comparison;
                IProcessingInfo info;
                if (j != i && (info = comparator.compare((IScanMSD)((IPeakMSD)Adapters.adapt((Object)(comparison = (IPeak)candidatePeakSet.get(j)), IPeakMSD.class)).getExtractedMassSpectrum(), (IScanMSD)((IPeakMSD)Adapters.adapt((Object)candidate, IPeakMSD.class)).getExtractedMassSpectrum(), matchConstraints)) != null && (result = (IComparisonResult)info.getProcessingResult()) != null && (double)(matchFactor = result.getMatchFactor()) / 100.0 > minMatchFactor) {
                    PeakGroup<IPeak> group = new PeakGroup<IPeak>();
                    group.addPeak(candidate, i);
                    group.addPeak(comparison, j);
                    peakGroups.add(group);
                }
                ++j;
            }
            ++i;
        }
        int groups = peakGroups.size();
        int i2 = 0;
        while (i2 < groups) {
            PeakGroup current = (PeakGroup)peakGroups.get(i2);
            int j = 0;
            while (j < groups) {
                PeakGroup other;
                if (i2 != j && current.intersects(other = (PeakGroup)peakGroups.get(j))) {
                    current.merge(other);
                }
                ++j;
            }
            ++i2;
        }
        Iterator iterator = peakGroups.iterator();
        while (iterator.hasNext()) {
            PeakGroup peakGroup = (PeakGroup)iterator.next();
            if (!peakGroup.isEmpty()) continue;
            iterator.remove();
        }
        return peakGroups;
    }

    private static <T extends IPeak> void deletePeaks(List<PeakGroup<T>> list, CRUDListener<? super T, ?> listener, Comparator<T> compareFunction) {
        for (PeakGroup<T> peakGroup : list) {
            T maxPeak = peakGroup.getMaxPeak(compareFunction);
            if (maxPeak == null) continue;
            Collection<T> values = peakGroup.values();
            for (IPeak peak : values) {
                if (peak == maxPeak) continue;
                listener.delete((Object)peak);
            }
        }
    }

    private static int getRTDelta(IPeak p1, IPeak p2) {
        int rt1 = ((IPeakMSD)Adapters.adapt((Object)p1, IPeakMSD.class)).getExtractedMassSpectrum().getRetentionTime();
        int rt2 = ((IPeakMSD)Adapters.adapt((Object)p2, IPeakMSD.class)).getExtractedMassSpectrum().getRetentionTime();
        return rt1 - rt2;
    }

    public DataCategory[] getDataCategories() {
        return new DataCategory[]{DataCategory.MSD};
    }
}

