/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.identifier.peak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.IPeakIdentifierSupplierCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.IPeakIdentifierSupportCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.PeakIdentifierCSD;
import org.eclipse.chemclipse.chromatogram.csd.identifier.settings.IPeakIdentifierSettingsCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class PeakIdentifierCSDProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Peak Identifier";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        try {
            IPeakIdentifierSupportCSD support = PeakIdentifierCSD.getPeakIdentifierSupport();
            ArrayList list = new ArrayList();
            for (String processorId : support.getAvailableIdentifierIds()) {
                IPeakIdentifierSupplierCSD supplier = support.getIdentifierSupplier(processorId);
                list.add((IProcessSupplier<?>)new PeakIdentifierProcessorSupplier(supplier, this));
            }
            return list;
        }
        catch (NoIdentifierAvailableException e) {
            return Collections.emptyList();
        }
    }

    private static final class PeakIdentifierProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IPeakIdentifierSettingsCSD> {
        private IPeakIdentifierSupplierCSD supplier;

        public PeakIdentifierProcessorSupplier(IPeakIdentifierSupplierCSD supplier, IProcessTypeSupplier parent) {
            super("PeakIdentifierCSD." + supplier.getId(), supplier.getIdentifierName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.CSD});
            this.supplier = supplier;
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IPeakIdentifierSettingsCSD processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
                IChromatogramSelectionCSD chromatogramSelectionCSD = (IChromatogramSelectionCSD)chromatogramSelection;
                if (processSettings instanceof IPeakIdentifierSettingsCSD) {
                    messageConsumer.addMessages(PeakIdentifierCSD.identify(chromatogramSelectionCSD, processSettings, this.supplier.getId(), monitor));
                } else {
                    messageConsumer.addMessages(PeakIdentifierCSD.identify(chromatogramSelectionCSD, this.supplier.getId(), monitor));
                }
            } else {
                messageConsumer.addWarnMessage(this.getName(), "Only CSD chromatogram supported, skipp processing");
            }
            return chromatogramSelection;
        }

        public boolean matchesId(String id) {
            return super.matchesId(id) || this.supplier.getId().equals(id);
        }
    }
}

