/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.IChromatogramCSDZipWriter;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChromatogramWriter_1100
extends AbstractChromatogramWriter
implements IChromatogramCSDZipWriter {
    public void writeChromatogram(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeChromatogramFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "1.1.0.0";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Chromatogram", (int)100);
        try {
            ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.closeEntry();
            this.writeChromatogramMethod(zipOutputStream, directoryPrefix, chromatogram, monitor);
            subMonitor.worked(20);
            this.writeChromatogramScans(zipOutputStream, directoryPrefix, chromatogram, monitor);
            subMonitor.worked(20);
            this.writeChromatogramBaseline(zipOutputStream, directoryPrefix, chromatogram, monitor);
            subMonitor.worked(20);
            this.writeChromatogramPeaks(zipOutputStream, directoryPrefix, chromatogram, monitor);
            subMonitor.worked(20);
            this.writeChromatogramArea(zipOutputStream, directoryPrefix, chromatogram, monitor);
            subMonitor.worked(20);
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }

    private void writeChromatogramMethod(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/SYSTEM_SETTINGS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IMethod method = chromatogram.getMethod();
        this.writeString(dataOutputStream, method.getInstrumentName());
        this.writeString(dataOutputStream, method.getIonSource());
        dataOutputStream.writeDouble(method.getSamplingRate());
        dataOutputStream.writeInt(method.getSolventDelay());
        dataOutputStream.writeDouble(method.getSourceHeater());
        this.writeString(dataOutputStream, method.getStopMode());
        dataOutputStream.writeInt(method.getStopTime());
        dataOutputStream.writeInt(method.getTimeFilterPeakWidth());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            IScanCSD scanFID = chromatogram.getSupplierScan(scan);
            dataOutputStream.writeInt(scanFID.getRetentionTime());
            dataOutputStream.writeFloat(scanFID.getTotalSignal());
            dataOutputStream.writeInt(scanFID.getRetentionTimeColumn1());
            dataOutputStream.writeInt(scanFID.getRetentionTimeColumn2());
            dataOutputStream.writeFloat(scanFID.getRetentionIndex());
            dataOutputStream.writeBoolean(scanFID.hasAdditionalRetentionIndices());
            if (scanFID.hasAdditionalRetentionIndices()) {
                Map retentionIndicesTyped = scanFID.getRetentionIndicesTyped();
                dataOutputStream.writeInt(retentionIndicesTyped.size());
                for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                    this.writeString(dataOutputStream, ((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                    dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
                }
            }
            dataOutputStream.writeInt(scanFID.getTimeSegmentId());
            dataOutputStream.writeInt(scanFID.getCycleNumber());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackgroundAbundance(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        for (IChromatogramPeakCSD peak : peaks) {
            this.writePeak(dataOutputStream, (IPeakCSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "FID/CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        this.writeString(dataOutputStream, chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakCSD peak) throws IOException {
        IPeakModelCSD peakModel = peak.getPeakModel();
        this.writeString(dataOutputStream, peak.getDetectorDescription());
        this.writeString(dataOutputStream, peak.getQuantifierDescription());
        dataOutputStream.writeBoolean(peak.isActiveForAnalysis());
        this.writeString(dataOutputStream, peak.getIntegratorDescription());
        this.writeString(dataOutputStream, peak.getModelDescription());
        this.writeString(dataOutputStream, peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IScan scan = peakModel.getPeakMaximum();
        dataOutputStream.writeInt(scan.getRetentionTime());
        dataOutputStream.writeFloat(scan.getTotalSignal());
        dataOutputStream.writeInt(scan.getRetentionTimeColumn1());
        dataOutputStream.writeInt(scan.getRetentionTimeColumn2());
        dataOutputStream.writeFloat(scan.getRetentionIndex());
        dataOutputStream.writeBoolean(scan.hasAdditionalRetentionIndices());
        if (scan.hasAdditionalRetentionIndices()) {
            Map retentionIndicesTyped = scan.getRetentionIndicesTyped();
            dataOutputStream.writeInt(retentionIndicesTyped.size());
            for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                this.writeString(dataOutputStream, ((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
            }
        }
        dataOutputStream.writeInt(scan.getTimeSegmentId());
        dataOutputStream.writeInt(scan.getCycleNumber());
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)((Object)iterator.next());
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
        this.writeIntenalStandards(dataOutputStream, peak.getInternalStandards());
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            dataOutputStream.writeDouble(iIntegrationEntry.getIntegratedArea());
        }
    }

    private void writeIntenalStandards(DataOutputStream dataOutputStream, List<IInternalStandard> internalStandards) throws IOException {
        dataOutputStream.writeInt(internalStandards.size());
        for (IInternalStandard internalStandard : internalStandards) {
            this.writeString(dataOutputStream, internalStandard.getName());
            dataOutputStream.writeDouble(internalStandard.getConcentration());
            this.writeString(dataOutputStream, internalStandard.getConcentrationUnit());
            dataOutputStream.writeDouble(internalStandard.getResponseFactor());
            this.writeString(dataOutputStream, internalStandard.getChemicalClass());
        }
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

