/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.BaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.IBaselineDetectorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.IBaselineDetectorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.exceptions.NoBaselineDetectorAvailableException;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.settings.IBaselineDetectorSettings;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.supplier.ChromatogramSelectionProcessorSupplier;
import org.eclipse.chemclipse.model.types.DataType;
import org.eclipse.chemclipse.processing.core.MessageConsumer;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;
import org.eclipse.chemclipse.processing.supplier.IProcessTypeSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.osgi.service.component.annotations.Component;

@Component(service={IProcessTypeSupplier.class})
public class BaselineDetectorProcessTypeSupplier
implements IProcessTypeSupplier {
    public String getCategory() {
        return "Baseline Detector";
    }

    public Collection<IProcessSupplier<?>> getProcessorSuppliers() {
        ArrayList supplierList = new ArrayList();
        try {
            IBaselineDetectorSupport support = BaselineDetector.getBaselineDetectorSupport();
            for (String processorId : support.getAvailableDetectorIds()) {
                IBaselineDetectorSupplier supplier = support.getBaselineDetectorSupplier(processorId);
                supplierList.add((IProcessSupplier<?>)new BaselineDetectorProcessorSupplier(supplier, this));
            }
        }
        catch (NoBaselineDetectorAvailableException e) {
            Collections.emptyList();
        }
        return supplierList;
    }

    private static final class BaselineDetectorProcessorSupplier
    extends ChromatogramSelectionProcessorSupplier<IBaselineDetectorSettings> {
        public BaselineDetectorProcessorSupplier(IBaselineDetectorSupplier supplier, IProcessTypeSupplier parent) {
            super(supplier.getId(), supplier.getDetectorName(), supplier.getDescription(), supplier.getSettingsClass(), parent, new DataType[]{DataType.MSD, DataType.CSD, DataType.WSD});
        }

        public IChromatogramSelection<?, ?> apply(IChromatogramSelection<?, ?> chromatogramSelection, IBaselineDetectorSettings processSettings, MessageConsumer messageConsumer, IProgressMonitor monitor) {
            if (processSettings == null) {
                messageConsumer.addMessages((MessageProvider)BaselineDetector.setBaseline(chromatogramSelection, this.getId(), monitor));
            } else {
                messageConsumer.addMessages((MessageProvider)BaselineDetector.setBaseline(chromatogramSelection, processSettings, this.getId(), monitor));
            }
            return chromatogramSelection;
        }
    }
}

