/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.logging.ui.editors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LogFileEditor {
    public static final String ID = "org.eclipse.chemclipse.logging.ui.part.logfileEditor";
    public static final String CONTRIBUTION_URI = "bundleclass://org.eclipse.chemclipse.logging.ui/org.eclipse.chemclipse.logging.ui.editors.LogFileEditor";
    public static final String ICON_URI = "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/log.gif";
    public static final String TOOLTIP = "Log File Editor";
    private static final Logger logger = Logger.getLogger(LogFileEditor.class);
    private MDirtyable dirtyable;
    private File file;
    private Text textEditor;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    private MPart inputPart;

    @Inject
    public LogFileEditor(Composite parent, MPart part, MDirtyable dirtyable) {
        this.dirtyable = dirtyable;
        parent.setLayout((Layout)new FillLayout());
        this.inputPart = part;
        this.textEditor = new Text(parent, 2882);
        try {
            Object object = part.getObject();
            if (object instanceof String) {
                this.file = new File((String)object);
                String text = this.getInputFileContent();
                this.textEditor.setText(text);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
        }
    }

    @Focus
    public void setFocus() {
        this.textEditor.setFocus();
    }

    @PreDestroy
    private void preDestroy() {
        if (this.modelService != null) {
            MPartStack partStack = (MPartStack)this.modelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)this.application);
            this.inputPart.setToBeRendered(false);
            this.inputPart.setVisible(false);
            partStack.getChildren().remove(this.inputPart);
        }
    }

    @Persist
    public void save() {
        try {
            FileWriter fileWriter = new FileWriter(this.file);
            fileWriter.write(this.textEditor.getText());
            fileWriter.flush();
            fileWriter.close();
            this.dirtyable.setDirty(false);
        }
        catch (IOException e) {
            logger.warn((Object)e);
        }
    }

    private String getInputFileContent() throws Exception {
        String text = "";
        if (this.file != null) {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
            StringBuilder builder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line);
            }
            bufferedReader.close();
            text = builder.toString();
        }
        return text;
    }
}

