/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.chromatogram;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import org.eclipse.chemclipse.converter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.settings.AbstractProcessSettings;
import org.eclipse.chemclipse.model.settings.IProcessSettings;
import org.eclipse.chemclipse.support.settings.FileSettingProperty;
import org.eclipse.chemclipse.support.settings.SystemSettings;
import org.eclipse.chemclipse.support.settings.SystemSettingsStrategy;

@SystemSettings(value=SystemSettingsStrategy.DYNAMIC, dynamicCheckMethod="getSystemSettingsStrategy")
public class ChromatogramExportSettings
extends AbstractProcessSettings
implements IProcessSettings {
    public static final String VARIABLE_CHROMATOGRAM_NAME = "{chromatogram_name}";
    public static final String VARIABLE_EXTENSION = "{extension}";
    @JsonProperty(value="Export Folder", defaultValue="")
    @FileSettingProperty(onlyDirectory=true)
    private File exportFolder;
    @JsonProperty(value="Filename", defaultValue="{chromatogram_name}{extension}")
    private String filenamePattern = "{chromatogram_name}{extension}";

    public File getExportFolder() {
        String folder;
        if (this.exportFolder == null && (folder = PreferenceSupplier.getChromatogramExportFolder()) != null && !folder.isEmpty()) {
            return new File(folder);
        }
        return this.exportFolder;
    }

    public void setExportFolder(File exportFolder) {
        this.exportFolder = exportFolder;
    }

    public String getFileNamePattern() {
        if (this.filenamePattern == null) {
            return VARIABLE_CHROMATOGRAM_NAME;
        }
        return this.filenamePattern;
    }

    public static SystemSettingsStrategy getSystemSettingsStrategy() {
        String folder = PreferenceSupplier.getChromatogramExportFolder();
        if (folder != null && !folder.isEmpty()) {
            return SystemSettingsStrategy.NEW_INSTANCE;
        }
        return SystemSettingsStrategy.NONE;
    }

    @JsonIgnore
    public File getExportFileName(String extension, IChromatogram<?> chromatogram) {
        return new File(this.getExportFolder(), this.getFileNamePattern().replace(VARIABLE_CHROMATOGRAM_NAME, chromatogram.getName()).replace(VARIABLE_EXTENSION, extension));
    }
}

