/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.msd.converter.io.IMassSpectraWriter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.AbstractWriter;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractMassSpectraWriter
extends AbstractWriter
implements IMassSpectraWriter {
    private static final int MAX_SPECTRA_CHUNK = 65535;

    public void write(File file, IScanMSD massSpectrum, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileWriter fileWriter = new FileWriter(file, append);
        this.writeMassSpectrum(fileWriter, massSpectrum, monitor);
        fileWriter.close();
    }

    public void write(File file, IMassSpectra massSpectra, boolean append, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        if (massSpectra.size() > 65535 && PreferenceSupplier.isSplitLibrary()) {
            file.delete();
            List<IMassSpectra> splittedMassSpectra = this.getSplittedMassSpectra(massSpectra);
            int counter = 1;
            for (IMassSpectra massSpectraChunk : splittedMassSpectra) {
                String filePath = file.getAbsolutePath();
                String fileExtension = filePath.substring(filePath.lastIndexOf("."), filePath.length());
                filePath = filePath.replace(fileExtension, "-" + counter + fileExtension);
                FileWriter fileWriter = new FileWriter(new File(filePath), append);
                this.writeMassSpectra(fileWriter, massSpectraChunk, monitor);
                fileWriter.close();
                ++counter;
            }
        } else {
            FileWriter fileWriter = new FileWriter(file, append);
            this.writeMassSpectra(fileWriter, massSpectra, monitor);
            fileWriter.close();
        }
    }

    private List<IMassSpectra> getSplittedMassSpectra(IMassSpectra massSpectra) {
        ArrayList<IMassSpectra> splittedMassSpectra = new ArrayList<IMassSpectra>();
        MassSpectra massSpectraChunk = new MassSpectra();
        int counter = 1;
        int i = 1;
        while (i <= massSpectra.size()) {
            IScanMSD massSpectrum = massSpectra.getMassSpectrum(i);
            if (counter <= 65535) {
                massSpectraChunk.addMassSpectrum(massSpectrum);
                ++counter;
            } else {
                splittedMassSpectra.add((IMassSpectra)massSpectraChunk);
                massSpectraChunk = new MassSpectra();
                massSpectraChunk.addMassSpectrum(massSpectrum);
                counter = 1;
            }
            ++i;
        }
        splittedMassSpectra.add((IMassSpectra)massSpectraChunk);
        return splittedMassSpectra;
    }

    private void writeMassSpectra(FileWriter fileWriter, IMassSpectra massSpectra, IProgressMonitor monitor) throws IOException {
        int i = 1;
        while (i <= massSpectra.size()) {
            IScanMSD massSpectrum = massSpectra.getMassSpectrum(i);
            if (massSpectrum != null && massSpectrum.getNumberOfIons() > 0) {
                this.writeMassSpectrum(fileWriter, massSpectrum, monitor);
            }
            ++i;
        }
    }
}

