/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum;

import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparator;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparisonSupplier;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractMassSpectrumComparator
implements IMassSpectrumComparator {
    private static final String DESCRIPTION = "MassSpectrum Comparator";
    private static final Logger logger = Logger.getLogger(AbstractMassSpectrumComparator.class);
    private IMassSpectrumComparisonSupplier massSpectrumComparisonSupplier;

    @Override
    public IProcessingInfo<IComparisonResult> validate(IScanMSD unknown, IScanMSD reference) {
        String msg = null;
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (unknown == null) {
            msg = "The unknown mass spectum does not exists.";
            logger.error((Object)msg);
            processingInfo.addErrorMessage(DESCRIPTION, msg);
        } else if (unknown.getIons().size() == 0) {
            msg = "There is no ion in the unknown mass spectum.";
            logger.error((Object)msg);
            processingInfo.addErrorMessage(DESCRIPTION, msg);
        }
        if (reference == null) {
            msg = "The reference mass spectum does not exists.";
            logger.error((Object)msg);
            processingInfo.addErrorMessage(DESCRIPTION, msg);
        } else if (reference.getIons().size() == 0) {
            msg = "There is no ion in the reference mass spectum.";
            logger.error((Object)msg);
            processingInfo.addErrorMessage(DESCRIPTION, msg);
        }
        return processingInfo;
    }

    protected void setMassSpectrumComparisonSupplier(IMassSpectrumComparisonSupplier massSpectrumComparisonSupplier) {
        this.massSpectrumComparisonSupplier = massSpectrumComparisonSupplier;
    }

    @Override
    public IMassSpectrumComparisonSupplier getMassSpectrumComparisonSupplier() {
        return this.massSpectrumComparisonSupplier;
    }
}

