/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakIdentificationBatchJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.model.IPeakOutputEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.BatchProcessEditor;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.support.ConverterTypeSupport;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.wizards.BatchProcessWizardDialog;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.peakidentification.ui.internal.wizards.PeakOutputFilesWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class PeakOutputFilesPage
implements IMultiEditorPage {
    private FormToolkit toolkit;
    private int pageIndex;
    private IPeakIdentificationBatchJob peakIdentificationBatchJob;
    private Table outputFilesTable;

    public PeakOutputFilesPage(BatchProcessEditor editorPart, Composite container) {
        this.createPage(editorPart, container);
    }

    @Override
    public void setFocus() {
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
    }

    @Override
    public void setPeakIdentificationBatchJob(IPeakIdentificationBatchJob peakIdentificationBatchJob) {
        if (peakIdentificationBatchJob != null) {
            this.peakIdentificationBatchJob = peakIdentificationBatchJob;
            this.reloadTable();
        }
    }

    private void createPage(BatchProcessEditor editorPart, Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new FillLayout());
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm scrolledForm = this.toolkit.createScrolledForm(parent);
        Composite scrolledFormComposite = scrolledForm.getBody();
        scrolledFormComposite.setLayout((Layout)new TableWrapLayout());
        scrolledForm.setText("Output File Editor");
        this.createOutputFilesSection(scrolledFormComposite, editorPart);
        this.pageIndex = editorPart.addPage((Control)parent);
    }

    private void createOutputFilesSection(Composite parent, BatchProcessEditor editorPart) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setText("Output files");
        section.setDescription("Select the output file formats. Use the add and remove buttons.");
        section.marginWidth = 5;
        section.marginHeight = 5;
        section.setLayoutData((Object)new TableWrapData(256));
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        this.createTable(client);
        this.createButtons(client, editorPart);
        section.setClient((Control)client);
        this.toolkit.paintBordersFor(client);
    }

    private void createTable(Composite client) {
        this.outputFilesTable = this.toolkit.createTable(client, 2);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        gridData.widthHint = 100;
        gridData.verticalSpan = 2;
        this.outputFilesTable.setLayoutData((Object)gridData);
        this.outputFilesTable.setHeaderVisible(true);
        this.outputFilesTable.setLinesVisible(true);
    }

    private void createButtons(Composite client, BatchProcessEditor editorPart) {
        this.createAddButton(client, editorPart);
        this.createRemoveButton(client, editorPart);
    }

    private void createAddButton(Composite client, final BatchProcessEditor editorPart) {
        Button add = this.toolkit.createButton(client, "Add", 8);
        add.setLayoutData((Object)new GridData(258));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Shell shell = Display.getCurrent().getActiveShell();
                PeakOutputFilesWizard outputEntriesWizard = new PeakOutputFilesWizard();
                BatchProcessWizardDialog wizardDialog = new BatchProcessWizardDialog(shell, (IWizard)outputEntriesWizard);
                wizardDialog.create();
                int returnCode = wizardDialog.open();
                if (returnCode == 0) {
                    IPeakOutputEntry outputEntry = outputEntriesWizard.getPeakOutputEntry();
                    if (outputEntry != null) {
                        List outputEntries = PeakOutputFilesPage.this.peakIdentificationBatchJob.getPeakOutputEntries();
                        outputEntries.add(outputEntry);
                        PeakOutputFilesPage.this.reloadTable();
                        editorPart.setDirty();
                    } else {
                        MessageBox messageBox = new MessageBox(shell);
                        messageBox.setText("Error Add Output Entry");
                        messageBox.setMessage("Please select a valid peak output converter and folder.");
                        messageBox.open();
                    }
                }
            }
        });
    }

    private void createRemoveButton(Composite client, final BatchProcessEditor editorPart) {
        Button remove = this.toolkit.createButton(client, "Remove", 8);
        remove.setLayoutData((Object)new GridData(258));
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                PeakOutputFilesPage.this.removeEntries(PeakOutputFilesPage.this.outputFilesTable.getSelectionIndices());
                editorPart.setDirty();
            }
        });
    }

    private void removeEntries(int[] indices) {
        if (indices == null || indices.length == 0) {
            return;
        }
        this.outputFilesTable.remove(indices);
        List outputEntries = this.peakIdentificationBatchJob.getPeakOutputEntries();
        int counter = 0;
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            outputEntries.remove(index -= counter);
            ++counter;
            ++n2;
        }
    }

    private void reloadTable() {
        if (this.peakIdentificationBatchJob != null && this.outputFilesTable != null) {
            this.outputFilesTable.removeAll();
            String[] titles = new String[]{"Converter Name", "Output Folder", "Converter Id"};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.outputFilesTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            ConverterTypeSupport converterTypeSupport = new ConverterTypeSupport();
            List outputEntries = this.peakIdentificationBatchJob.getPeakOutputEntries();
            for (IPeakOutputEntry entry : outputEntries) {
                TableItem item = new TableItem(this.outputFilesTable, 0);
                item.setText(0, converterTypeSupport.getConverterName(entry));
                item.setText(1, entry.getOutputFolder());
                item.setText(2, entry.getConverterId());
            }
            int i2 = 0;
            while (i2 < titles.length) {
                this.outputFilesTable.getColumn(i2).pack();
                ++i2;
            }
        }
    }
}

