/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.PcaUtils;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AbstractFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class CVFilter
extends AbstractFilter
implements IFilter {
    private double alpha = 0.7;
    private final String name = "CV filter";
    private String selectionResult = "";

    public CVFilter() {
        super(IFilter.DataTypeProcessing.RAW_DATA);
    }

    @Override
    public <V extends IVariable, S extends ISample> List<Boolean> filter(ISamples<V, S> samples) {
        List<S> samplesList = this.selectSamples(samples);
        ArrayList<Boolean> selection = new ArrayList<Boolean>();
        List variables = samples.getVariables();
        int i = 0;
        while (i < variables.size()) {
            selection.add(false);
            ++i;
        }
        Map<String, Set<S>> samplesByGroupNameMap = PcaUtils.getSamplesByGroupName(samplesList, false, this.isOnlySelected());
        Collection<Set<S>> samplesByGroupName = samplesByGroupNameMap.values();
        if (!samplesByGroupName.isEmpty()) {
            int i2 = 0;
            while (i2 < variables.size()) {
                ArrayList<SummaryStatistics> categoryData = new ArrayList<SummaryStatistics>();
                for (Set<S> set : samplesByGroupName) {
                    SummaryStatistics summaryStatistics = new SummaryStatistics();
                    for (ISample sample : set) {
                        double d = this.getData((ISampleData)sample.getSampleData().get(i2));
                        summaryStatistics.addValue(d);
                    }
                    categoryData.add(summaryStatistics);
                }
                boolean result = ((Stream)categoryData.stream().parallel()).allMatch(s -> {
                    double m = Math.abs(s.getMean());
                    double d = s.getStandardDeviation();
                    if (m != 0.0) {
                        return d / m < this.alpha;
                    }
                    return d == 0.0;
                });
                selection.set(i2, result);
                ++i2;
            }
        }
        this.selectionResult = IFilter.getNumberSelectedRow(selection);
        return selection;
    }

    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public String getDescription() {
        return "Noise for each group is less than " + this.alpha * 100.0 + "%";
    }

    @Override
    public String getName() {
        return "CV filter";
    }

    @Override
    public String getSelectionResult() {
        return this.selectionResult;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }
}

