/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import org.eclipse.chemclipse.model.quantitation.IResponseSignal;

public class ResponseSignal
implements IResponseSignal {
    private static final long serialVersionUID = -4768367983343261439L;
    private double signal = 0.0;
    private double concentration = 0.0;
    private double response = 0.0;

    public ResponseSignal(double signal, double concentration, double response) {
        this.signal = signal;
        this.concentration = concentration;
        this.response = response;
    }

    @Override
    public double getSignal() {
        return this.signal;
    }

    @Override
    public double getConcentration() {
        return this.concentration;
    }

    @Override
    public double getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(double response) {
        this.response = response;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.concentration);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.signal);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResponseSignal other = (ResponseSignal)obj;
        if (Double.doubleToLongBits(this.concentration) != Double.doubleToLongBits(other.concentration)) {
            return false;
        }
        return Double.doubleToLongBits(this.signal) == Double.doubleToLongBits(other.signal);
    }

    public String toString() {
        return "AbstractConcentrationResponseEntry [signal=" + this.signal + ", concentration=" + this.concentration + ", response=" + this.response + "]";
    }
}

