/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.selection;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.model.selection.MoveDirection;

public class ChromatogramSelectionSupport {
    private ChromatogramSelectionSupport() {
    }

    public static void moveRetentionTimeWindow(IChromatogramSelection chromatogramSelection, MoveDirection moveDirection, int retentionTimeDivider) {
        int startRetentionTime = chromatogramSelection.getStartRetentionTime();
        int stopRetentionTime = chromatogramSelection.getStopRetentionTime();
        int retentionTimeMoveWindow = (stopRetentionTime - startRetentionTime) / retentionTimeDivider;
        int startRetentionTimeNew = MoveDirection.LEFT.equals((Object)moveDirection) ? startRetentionTime - retentionTimeMoveWindow : startRetentionTime + retentionTimeMoveWindow;
        int stopRetentionTimeNew = MoveDirection.LEFT.equals((Object)moveDirection) ? stopRetentionTime - retentionTimeMoveWindow : stopRetentionTime + retentionTimeMoveWindow;
        startRetentionTimeNew = ChromatogramSelectionSupport.getValidatedStartRetentionTime(chromatogramSelection, startRetentionTimeNew);
        stopRetentionTimeNew = ChromatogramSelectionSupport.getValidatedStopRetentionTime(chromatogramSelection, stopRetentionTimeNew);
        chromatogramSelection.setRanges(startRetentionTimeNew, stopRetentionTimeNew, chromatogramSelection.getStartAbundance(), chromatogramSelection.getStopAbundance());
    }

    public static int getValidatedStartRetentionTime(IChromatogramSelection chromatogramSelection, int startRetentionTimeNew) {
        Object chromatogram = chromatogramSelection.getChromatogram();
        int minRetentionTime = chromatogram.getStartRetentionTime();
        if (startRetentionTimeNew < minRetentionTime) {
            return minRetentionTime;
        }
        return startRetentionTimeNew;
    }

    public static int getValidatedStopRetentionTime(IChromatogramSelection chromatogramSelection, int stopRetentionTimeNew) {
        Object chromatogram = chromatogramSelection.getChromatogram();
        int maxRetentionTime = chromatogram.getStopRetentionTime();
        if (stopRetentionTimeNew > maxRetentionTime) {
            return maxRetentionTime;
        }
        return stopRetentionTimeNew;
    }
}

