/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.statistics;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.chemclipse.model.statistics.AbstractVariable;
import org.eclipse.chemclipse.model.statistics.IRetentionTime;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class RetentionTime
extends AbstractVariable
implements IRetentionTime {
    private NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private int retentionTime;

    public static List<RetentionTime> create(List<Integer> retentionTimes) {
        ArrayList<RetentionTime> retentionTimesList = new ArrayList<RetentionTime>();
        int i = 0;
        while (i < retentionTimes.size()) {
            retentionTimesList.add(new RetentionTime(retentionTimes.get(i)));
            ++i;
        }
        return retentionTimesList;
    }

    public RetentionTime(int retentioTime) {
        this.retentionTime = retentioTime;
        this.setValue(this.convertValue());
        this.setType("Retention Time [min]");
        this.setSelected(true);
    }

    public RetentionTime(int retentionTime, String description) {
        this(retentionTime);
        this.setDescription(description);
    }

    @Override
    public int compareTo(IVariable o) {
        if (o instanceof IRetentionTime) {
            IRetentionTime retentionTime = (IRetentionTime)o;
            return Integer.compare(this.getRetentionTime(), retentionTime.getRetentionTime());
        }
        return 0;
    }

    private String convertValue() {
        return this.nf.format(this.getRetentionTimeMinutes());
    }

    @Override
    public int getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public double getRetentionTimeMinutes() {
        return (double)this.retentionTime / 60000.0;
    }

    @Override
    public void setRetentioTime(int retentionTime) {
        this.retentionTime = retentionTime;
        this.setValue(this.convertValue());
    }
}

