/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.ScanIon;

public class VendorMassSpectrum
extends AbstractVendorMassSpectrum
implements IVendorMassSpectrum {
    private static final long serialVersionUID = 6529896871219884041L;
    private static final Logger logger = Logger.getLogger(VendorMassSpectrum.class);
    public static final int MAX_IONS = 65535;
    public static final int MIN_RETENTION_TIME = 0;
    public static final int MAX_RETENTION_TIME = Integer.MAX_VALUE;

    @Override
    public int getMaxPossibleIons() {
        return 65535;
    }

    @Override
    public int getMaxPossibleRetentionTime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinPossibleRetentionTime() {
        return 0;
    }

    @Override
    public IVendorMassSpectrum makeDeepCopy() throws CloneNotSupportedException {
        IVendorMassSpectrum massSpectrum = (IVendorMassSpectrum)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                ScanIon defaultIon = new ScanIon(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon(defaultIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

