/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.wsd.filter.core.peak;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.settings.IPeakFilterSettings;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.peak.IPeakFilter;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.peak.IPeakFilterSupport;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.peak.PeakFilterSupplier;
import org.eclipse.chemclipse.chromatogram.wsd.filter.core.peak.PeakFilterSupport;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.wsd.model.core.IPeakWSD;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakFilter {
    private static final Logger logger = Logger.getLogger(PeakFilter.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.wsd.filter.peakFilterSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filterName";
    private static final String FILTER = "filter";
    private static final String PROCESSING_DESCRIPTION = "Peak Filter";
    private static final String NO_PEAK_FILTER_AVAILABLE = "There is no peak filter available.";

    private PeakFilter() {
    }

    public static IProcessingInfo applyFilter(IPeakWSD peak, IPeakFilterSettings peakFilterSettings, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IPeakFilter peakFilter = PeakFilter.getPeakFilter(filterId);
        if (peakFilter != null) {
            processingInfo = peakFilter.applyFilter(peak, peakFilterSettings, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_PEAK_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo applyFilter(IPeakWSD peak, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IPeakFilter peakFilter = PeakFilter.getPeakFilter(filterId);
        if (peakFilter != null) {
            processingInfo = peakFilter.applyFilter(peak, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_PEAK_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo applyFilter(List<IPeakWSD> peaks, IPeakFilterSettings peakFilterSettings, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IPeakFilter peakFilter = PeakFilter.getPeakFilter(filterId);
        if (peakFilter != null) {
            processingInfo = peakFilter.applyFilter(peaks, peakFilterSettings, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_PEAK_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo applyFilter(List<IPeakWSD> peaks, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IPeakFilter peakFilter = PeakFilter.getPeakFilter(filterId);
        if (peakFilter != null) {
            processingInfo = peakFilter.applyFilter(peaks, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_PEAK_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo applyFilter(IChromatogramSelectionWSD chromatogramSelection, IPeakFilterSettings peakFilterSettings, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IPeakFilter peakFilter = PeakFilter.getPeakFilter(filterId);
        if (peakFilter != null) {
            processingInfo = peakFilter.applyFilter(chromatogramSelection, peakFilterSettings, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_PEAK_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IProcessingInfo applyFilter(IChromatogramSelectionWSD chromatogramSelection, String filterId, IProgressMonitor monitor) {
        ProcessingInfo processingInfo;
        IPeakFilter peakFilter = PeakFilter.getPeakFilter(filterId);
        if (peakFilter != null) {
            processingInfo = peakFilter.applyFilter(chromatogramSelection, monitor);
        } else {
            processingInfo = new ProcessingInfo();
            processingInfo.addErrorMessage(PROCESSING_DESCRIPTION, NO_PEAK_FILTER_AVAILABLE);
        }
        return processingInfo;
    }

    public static IPeakFilterSupport getPeakFilterSupport() {
        IConfigurationElement[] extensions;
        PeakFilterSupport filterSupport = new PeakFilterSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakFilterSupplier supplier = new PeakFilterSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setFilterName(element.getAttribute(FILTER_NAME));
            filterSupport.add(supplier);
            ++n2;
        }
        return filterSupport;
    }

    private static IPeakFilter getPeakFilter(String filterId) {
        IConfigurationElement element = PeakFilter.getConfigurationElement(filterId);
        IPeakFilter instance = null;
        if (element != null) {
            try {
                instance = (IPeakFilter)element.createExecutableExtension(FILTER);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

