/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator.CodaCalculator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator.IMassChromatographicQualityResult;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.exceptions.CodaCalculatorException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ChromatogramIsNullException;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.support.IMarkedIons;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIon;
import org.eclipse.chemclipse.msd.model.core.support.MarkedIons;
import org.eclipse.chemclipse.msd.model.xic.ExtractedIonSignalExtractor;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;

public class MassChromatographicQualityResult
implements IMassChromatographicQualityResult {
    private static final Logger logger = Logger.getLogger(MassChromatographicQualityResult.class);
    private float dataReductionValue;
    private IMarkedIons excludedIons;

    public MassChromatographicQualityResult(IChromatogramSelectionMSD chromatogramSelection, float codaThreshold, WindowSize windowSize) throws CodaCalculatorException {
        this.validateChromatogramSelection(chromatogramSelection);
        this.validateWindowSize(windowSize);
        this.excludedIons = new MarkedIons(IMarkedIons.IonMarkMode.INCLUDE);
        this.calculateMassChromatographicQuality(chromatogramSelection, codaThreshold, windowSize, this.excludedIons);
    }

    @Override
    public IMarkedIons getExcludedIons() {
        return this.excludedIons;
    }

    @Override
    public float getDataReductionValue() {
        return this.dataReductionValue;
    }

    private void calculateMassChromatographicQuality(IChromatogramSelectionMSD chromatogramSelection, float codaThreshold, WindowSize windowSize, IMarkedIons excludedIons) {
        assert (chromatogramSelection != null) : "The chromatogram selection must not be null.";
        assert (chromatogramSelection.getChromatogram() != null) : "The chromatogram must not be null.";
        assert (windowSize != null) : "The window size must not be null.";
        assert (excludedIons != null) : "The excluded ions must not be null.";
        ArrayList<Float> mcqs = new ArrayList<Float>();
        IChromatogramMSD chromatogram = chromatogramSelection.getChromatogramMSD();
        try {
            ExtractedIonSignalExtractor extractedIonSignalExtractor = new ExtractedIonSignalExtractor(chromatogram);
            IExtractedIonSignals extractedIonSignals = extractedIonSignalExtractor.getExtractedIonSignals((IRetentionTimeRange)chromatogramSelection);
            int startIon = extractedIonSignals.getStartIon();
            int stopIon = extractedIonSignals.getStopIon();
            int ion = startIon;
            while (ion <= stopIon) {
                float mcq = CodaCalculator.getMCQValue(extractedIonSignals, windowSize, ion);
                if (mcq < codaThreshold) {
                    excludedIons.add((Object)new MarkedIon((double)ion));
                }
                mcqs.add(Float.valueOf(mcq));
                ++ion;
            }
        }
        catch (ChromatogramIsNullException e) {
            logger.warn((Object)e);
        }
        this.dataReductionValue = this.calculateDataReductionValue(mcqs, codaThreshold);
    }

    private float calculateDataReductionValue(List<Float> mcqs, float codaThreshold) {
        float selected = 0.0f;
        if (mcqs == null || mcqs.size() < 1) {
            return 0.0f;
        }
        for (Float f : mcqs) {
            if (!(f.floatValue() >= codaThreshold)) continue;
            selected += 1.0f;
        }
        return selected / (float)mcqs.size();
    }

    private void validateWindowSize(WindowSize windowSize) throws CodaCalculatorException {
        if (windowSize == null) {
            throw new CodaCalculatorException("The window size must not be null.");
        }
    }

    private void validateChromatogramSelection(IChromatogramSelectionMSD chromatogramSelection) throws CodaCalculatorException {
        if (chromatogramSelection == null) {
            throw new CodaCalculatorException("The chromatogram selection must not be null.");
        }
        if (chromatogramSelection.getChromatogramMSD() == null) {
            throw new CodaCalculatorException("The chromatogram must not be null.");
        }
    }
}

