/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.export.core.AbstractSeriesExportHandler;
import org.eclipse.swtchart.export.core.AxisSettings;
import org.eclipse.swtchart.export.core.ExportSettingsDialog;
import org.eclipse.swtchart.export.core.ISeriesExportConverter;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;

public abstract class AbstractSeparatedValueHandler
extends AbstractSeriesExportHandler
implements ISeriesExportConverter {
    private String title;
    private String fileExtension;
    private String delimiter;

    public AbstractSeparatedValueHandler(String title, String fileExtension, String delimiter) {
        this.title = title;
        this.fileExtension = fileExtension;
        this.delimiter = delimiter;
    }

    public void execute(Shell shell, ScrollableChart scrollableChart) {
        BaseChart baseChart = scrollableChart.getBaseChart();
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setOverwrite(true);
        fileDialog.setText(this.title);
        fileDialog.setFilterExtensions(new String[]{this.fileExtension});
        String fileName = fileDialog.open();
        if (fileName != null) {
            ExportSettingsDialog exportSettingsDialog = new ExportSettingsDialog(shell, baseChart);
            exportSettingsDialog.create();
            if (exportSettingsDialog.open() == 0) {
                int indexAxisX = exportSettingsDialog.getIndexAxisSelectionX();
                int indexAxisY = exportSettingsDialog.getIndexAxisSelectionY();
                if (indexAxisX >= 0 && indexAxisY >= 0) {
                    IAxisSettings axisSettingsX = baseChart.getXAxisSettings(indexAxisX);
                    IAxisScaleConverter axisScaleConverterX = null;
                    if (axisSettingsX instanceof ISecondaryAxisSettings) {
                        ISecondaryAxisSettings secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsX;
                        axisScaleConverterX = secondaryAxisSettings.getAxisScaleConverter();
                    }
                    IAxisSettings axisSettingsY = baseChart.getYAxisSettings(indexAxisY);
                    IAxisScaleConverter axisScaleConverterY = null;
                    if (axisSettingsY instanceof ISecondaryAxisSettings) {
                        ISecondaryAxisSettings secondaryAxisSettings = (ISecondaryAxisSettings)axisSettingsY;
                        axisScaleConverterY = secondaryAxisSettings.getAxisScaleConverter();
                    }
                    try (PrintWriter printWriter = null;){
                        try {
                            ISeries[] series;
                            printWriter = new PrintWriter(new File(fileName));
                            printWriter.print(axisSettingsX.getLabel());
                            printWriter.print(this.delimiter);
                            printWriter.println(axisSettingsY.getLabel());
                            boolean exportVisibleOnly = exportSettingsDialog.isExportVisibleOnly();
                            AxisSettings axisSettings = new AxisSettings();
                            axisSettings.setIndexAxisX(indexAxisX);
                            axisSettings.setIndexAxisY(indexAxisY);
                            axisSettings.setAxisSettingsX(axisSettingsX);
                            axisSettings.setAxisScaleConverterX(axisScaleConverterX);
                            axisSettings.setAxisSettingsY(axisSettingsY);
                            axisSettings.setAxisScaleConverterY(axisScaleConverterY);
                            axisSettings.setExportVisibleOnly(exportVisibleOnly);
                            int widthPlotArea = baseChart.getPlotArea().getSize().x;
                            ISeries[] iSeriesArray = series = baseChart.getSeriesSet().getSeries();
                            int n = series.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ISeries dataSeries = iSeriesArray[n2];
                                if (dataSeries != null) {
                                    if (exportVisibleOnly) {
                                        if (dataSeries.isVisible()) {
                                            this.exportSeries(dataSeries, widthPlotArea, axisSettings, printWriter);
                                        }
                                    } else {
                                        this.exportSeries(dataSeries, widthPlotArea, axisSettings, printWriter);
                                    }
                                }
                                ++n2;
                            }
                            printWriter.flush();
                            MessageDialog.openInformation((Shell)shell, (String)this.title, (String)MESSAGE_OK);
                        }
                        catch (FileNotFoundException e) {
                            MessageDialog.openError((Shell)shell, (String)this.title, (String)MESSAGE_ERROR);
                            System.out.println(e);
                            if (printWriter != null) {
                                printWriter.close();
                            }
                        }
                    }
                }
            }
        }
    }

    private void exportSeries(ISeries<?> dataSeries, int widthPlotArea, AxisSettings axisSettings, PrintWriter printWriter) {
        int indexAxisX = axisSettings.getIndexAxisX();
        int indexAxisY = axisSettings.getIndexAxisY();
        IAxisSettings axisSettingsX = axisSettings.getAxisSettingsX();
        DecimalFormat decimalFormatX = axisSettingsX.getDecimalFormat();
        IAxisScaleConverter axisScaleConverterX = axisSettings.getAxisScaleConverterX();
        IAxisSettings axisSettingsY = axisSettings.getAxisSettingsY();
        DecimalFormat decimalFormatY = axisSettingsY.getDecimalFormat();
        IAxisScaleConverter axisScaleConverterY = axisSettings.getAxisScaleConverterY();
        printWriter.println(dataSeries.getId());
        double[] xSeries = dataSeries.getXSeries();
        double[] ySeries = dataSeries.getYSeries();
        int size = dataSeries.getXSeries().length;
        int i = 0;
        while (i < size) {
            Point point = dataSeries.getPixelCoordinates(i);
            if (point.x >= 0 && point.x <= widthPlotArea) {
                this.printValue(printWriter, xSeries[i], indexAxisX, 0, decimalFormatX, axisScaleConverterX);
                printWriter.print(this.delimiter);
                this.printValue(printWriter, ySeries[i], indexAxisY, 0, decimalFormatY, axisScaleConverterY);
                printWriter.println("");
            }
            ++i;
        }
        printWriter.println("");
    }

    private void printValue(PrintWriter printWriter, double value, int indexAxis, int indexPrimaryAxis, DecimalFormat decimalFormat, IAxisScaleConverter axisScaleConverter) {
        if (indexAxis == indexPrimaryAxis) {
            printWriter.print(value);
        } else if (axisScaleConverter != null) {
            printWriter.print(decimalFormat.format(axisScaleConverter.convertToSecondaryUnit(value)));
        } else {
            printWriter.print(decimalFormat.format(value));
        }
    }
}

