/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.provider;

import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIon;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.provider.AbstractChemClipseLabelProvider;
import org.eclipse.swt.graphics.Image;

public class WncIonLabelProvider
extends AbstractChemClipseLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof IWncIon) {
            IWncIon wncIon = (IWncIon)element;
            switch (columnIndex) {
                case 0: {
                    text = wncIon.getName();
                    break;
                }
                case 1: {
                    int ion = wncIon.getIon();
                    if ((double)ion == 0.0) {
                        text = "TIC";
                        break;
                    }
                    text = Integer.toString(ion);
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }

    public Image getImage(Object element) {
        return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/ion.gif", "16x16");
    }
}

