/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.identifier.supplier.nist.ui.runnables;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.IExtendedRuntimeSupport;
import org.eclipse.chemclipse.msd.identifier.supplier.nist.runtime.RuntimeSupportFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class OpenNistGuiRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(OpenNistGuiRunnable.class);
    private static final String DESCRIPTION = "Open NIST-DB GUI";

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(DESCRIPTION, -1);
                File folder = PreferenceSupplier.getNistInstallationFolder();
                if (PreferenceSupplier.validateLocation((File)folder).isOK()) {
                    IExtendedRuntimeSupport runtimeSupport = RuntimeSupportFactory.getRuntimeSupport((File)folder);
                    runtimeSupport.executeOpenCommand();
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

