/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.filter.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.filter.impl.AbstractTransferFilter;
import org.eclipse.chemclipse.chromatogram.filter.impl.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.filter.impl.settings.ScanTargetsToPeakSettings;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.LibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class ScanTargetsToPeakFilter
extends AbstractTransferFilter {
    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        IProcessingInfo processingInfo = this.validate(chromatogramSelection, chromatogramFilterSettings);
        if (!processingInfo.hasErrorMessages() && chromatogramFilterSettings instanceof ScanTargetsToPeakSettings) {
            ScanTargetsToPeakSettings settings = (ScanTargetsToPeakSettings)chromatogramFilterSettings;
            this.transferTargets(chromatogramSelection, settings);
            processingInfo.setProcessingResult((Object)new ChromatogramFilterResult(ResultStatus.OK, "Targets transfered successfully."));
        }
        return processingInfo;
    }

    public IProcessingInfo applyFilter(IChromatogramSelection chromatogramSelection, IProgressMonitor monitor) {
        ScanTargetsToPeakSettings settings = PreferenceSupplier.getScanToPeakTargetTransferSettings();
        return this.applyFilter(chromatogramSelection, (IChromatogramFilterSettings)settings, monitor);
    }

    private void transferTargets(IChromatogramSelection chromatogramSelection, ScanTargetsToPeakSettings settings) {
        List<IScan> identifiedScans = this.extractIdentifiedScans(chromatogramSelection);
        List<? extends IPeak> peaks = this.extractPeaks(chromatogramSelection);
        for (IPeak iPeak : peaks) {
            List<IScan> targetScans = this.getScansInPeakRange(iPeak, identifiedScans, settings);
            for (IScan targetScan : targetScans) {
                for (IIdentificationTarget sourceTarget : targetScan.getTargets()) {
                    LibraryInformation libraryInformation = new LibraryInformation(sourceTarget.getLibraryInformation());
                    ComparisonResult comparisonResult = new ComparisonResult(sourceTarget.getComparisonResult());
                    IdentificationTarget sinkTarget = new IdentificationTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                    iPeak.getTargets().add(sinkTarget);
                }
            }
        }
    }

    private List<IScan> getScansInPeakRange(IPeak peak, List<IScan> scans, ScanTargetsToPeakSettings settings) {
        ArrayList<IScan> targetScans = new ArrayList<IScan>();
        IPeakModel peakModel = peak.getPeakModel();
        int startRetentionTime = peakModel.getStartRetentionTime();
        int stopRetentionTime = peakModel.getStopRetentionTime();
        int peakMaxRetentionTime = peakModel.getRetentionTimeAtPeakMaximum();
        boolean transferClosestScan = settings.isTransferClosestScan();
        for (IScan scan : scans) {
            IScan scanClosest;
            int deltaClosest;
            int retentionTime = scan.getRetentionTime();
            if (retentionTime < startRetentionTime || retentionTime > stopRetentionTime) continue;
            if (!transferClosestScan) {
                targetScans.add(scan);
                continue;
            }
            if (targetScans.isEmpty()) {
                targetScans.add(scan);
                continue;
            }
            int delta = Math.abs(peakMaxRetentionTime - scan.getRetentionTime());
            if (delta >= (deltaClosest = Math.abs(peakMaxRetentionTime - (scanClosest = (IScan)targetScans.get(0)).getRetentionTime()))) continue;
            targetScans.clear();
            targetScans.add(scan);
        }
        return targetScans;
    }
}

