/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.IPeakIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.IPeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.exceptions.NoIntegratorAvailableException;

public class PeakIntegratorSupport
implements IPeakIntegratorSupport {
    List<IPeakIntegratorSupplier> suppliers = new ArrayList<IPeakIntegratorSupplier>();

    protected void add(IPeakIntegratorSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public List<String> getAvailableIntegratorIds() throws NoIntegratorAvailableException {
        this.arePeakIntegratorsStored();
        ArrayList<String> availableIntegrators = new ArrayList<String>();
        for (IPeakIntegratorSupplier supplier : this.suppliers) {
            availableIntegrators.add(supplier.getId());
        }
        return availableIntegrators;
    }

    @Override
    public IPeakIntegratorSupplier getIntegratorSupplier(String integratorId) throws NoIntegratorAvailableException {
        IPeakIntegratorSupplier integratorSupplier = null;
        this.arePeakIntegratorsStored();
        if (integratorId == null || integratorId.equals("")) {
            throw new NoIntegratorAvailableException("There is no integrator available with the following id: " + integratorId + ".");
        }
        for (IPeakIntegratorSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(integratorId)) continue;
            integratorSupplier = supplier;
            break;
        }
        if (integratorSupplier == null) {
            throw new NoIntegratorAvailableException("There is no integrator available with the following id: " + integratorId + ".");
        }
        return integratorSupplier;
    }

    @Override
    public String getIntegratorId(int index) throws NoIntegratorAvailableException {
        this.arePeakIntegratorsStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoIntegratorAvailableException("There is no integrator available with the following id: " + index + ".");
        }
        IPeakIntegratorSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String[] getIntegratorNames() throws NoIntegratorAvailableException {
        this.arePeakIntegratorsStored();
        ArrayList<String> integratorNames = new ArrayList<String>();
        for (IPeakIntegratorSupplier supplier : this.suppliers) {
            integratorNames.add(supplier.getIntegratorName());
        }
        return integratorNames.toArray(new String[integratorNames.size()]);
    }

    private void arePeakIntegratorsStored() throws NoIntegratorAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoIntegratorAvailableException();
        }
    }
}

