/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.support;

import org.eclipse.chemclipse.chromatogram.xxd.integrator.support.ISegment;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.equations.Equations;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.exceptions.SolverException;

public class SegmentAreaCalculator {
    private SegmentAreaCalculator() {
    }

    public static double calculateSegmentArea(ISegment segment) {
        double area = 0.0;
        IPoint pbp1 = segment.getPeakBaselinePoint1();
        IPoint pbp2 = segment.getPeakBaselinePoint2();
        IPoint cbp1 = segment.getChromatogramBaselinePoint1();
        IPoint cbp2 = segment.getChromatogramBaselinePoint2();
        if (cbp1 == null || cbp2 == null || pbp1 == null || pbp2 == null) {
            return area;
        }
        if (SegmentAreaCalculator.crossingBaselinesInGivenRange(segment)) {
            try {
                IPoint intersection = SegmentAreaCalculator.calculateBaselineIntersection(segment);
                double c = 0.0;
                double h = intersection.getX() - pbp1.getX();
                double a = pbp1.getY() - cbp1.getY();
                area += SegmentAreaCalculator.calculateTrapeziumArea(a, c, h);
                h = pbp2.getX() - intersection.getX();
                a = pbp2.getY() - cbp2.getY();
                area += SegmentAreaCalculator.calculateTrapeziumArea(a, c, h);
            }
            catch (SolverException e) {
                area = 0.0;
            }
        } else {
            double a = pbp1.getY() - cbp1.getY();
            double c = pbp2.getY() - cbp2.getY();
            double h = pbp2.getX() - pbp1.getX();
            area = SegmentAreaCalculator.calculateTrapeziumArea(a, c, h);
        }
        return area;
    }

    private static double calculateTrapeziumArea(double a, double c, double h) {
        return (a + c) / 2.0 * h;
    }

    private static boolean crossingBaselinesInGivenRange(ISegment segment) {
        return SegmentAreaCalculator.crossingBaselinesPositive(segment) || SegmentAreaCalculator.crossingBaselinesNegative(segment);
    }

    private static boolean crossingBaselinesPositive(ISegment segment) {
        IPoint cbp1 = segment.getChromatogramBaselinePoint1();
        IPoint cbp2 = segment.getChromatogramBaselinePoint2();
        IPoint pbp1 = segment.getPeakBaselinePoint1();
        IPoint pbp2 = segment.getPeakBaselinePoint2();
        if (cbp1 == null || cbp2 == null || pbp1 == null || pbp2 == null) {
            return false;
        }
        return cbp1.getY() > pbp1.getY() && cbp2.getY() < pbp2.getY();
    }

    private static boolean crossingBaselinesNegative(ISegment segment) {
        IPoint cbp1 = segment.getChromatogramBaselinePoint1();
        IPoint cbp2 = segment.getChromatogramBaselinePoint2();
        IPoint pbp1 = segment.getPeakBaselinePoint1();
        IPoint pbp2 = segment.getPeakBaselinePoint2();
        if (cbp1 == null || cbp2 == null || pbp1 == null || pbp2 == null) {
            return false;
        }
        return cbp1.getY() < pbp1.getY() && cbp2.getY() > pbp2.getY();
    }

    private static IPoint calculateBaselineIntersection(ISegment segment) throws SolverException {
        LinearEquation peakBaseline = Equations.createLinearEquation((IPoint)segment.getPeakBaselinePoint1(), (IPoint)segment.getPeakBaselinePoint2());
        LinearEquation chromatogramBaseline = Equations.createLinearEquation((IPoint)segment.getChromatogramBaselinePoint1(), (IPoint)segment.getChromatogramBaselinePoint2());
        return Equations.calculateIntersection((LinearEquation)peakBaseline, (LinearEquation)chromatogramBaseline);
    }
}

