/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.nmr.model.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.chemclipse.model.core.IComplexSignalMeasurement;
import org.eclipse.chemclipse.nmr.model.selection.IDataNMRSelection;

public class DataNMRSelection
extends Observable
implements IDataNMRSelection {
    private List<IComplexSignalMeasurement<?>> measurements = new ArrayList();
    private IComplexSignalMeasurement<?> measurement;
    private String name;

    public DataNMRSelection() {
        this("NMR");
    }

    public DataNMRSelection(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized IComplexSignalMeasurement<?> getMeasurement() {
        return this.measurement;
    }

    @Override
    public void replace(IComplexSignalMeasurement<?> measurement, IComplexSignalMeasurement<?> replacement) {
        int indexOf = this.measurements.indexOf(measurement);
        if (indexOf > 0) {
            this.measurements.set(indexOf, replacement);
            if (this.measurement == measurement) {
                this.setActiveMeasurement(replacement);
            }
        }
    }

    @Override
    public synchronized void addMeasurement(IComplexSignalMeasurement<?> measurement) {
        if (!this.measurements.contains(measurement)) {
            this.measurements.add(measurement);
            this.setActiveMeasurement(measurement);
            this.setChanged();
            this.notifyObservers((Object)IDataNMRSelection.ChangeType.NEW_ITEM);
        }
    }

    @Override
    public void setActiveMeasurement(IComplexSignalMeasurement<?> measurement) {
        if (measurement == null || this.measurements.contains(measurement)) {
            this.measurement = measurement;
            this.setChanged();
            this.notifyObservers((Object)IDataNMRSelection.ChangeType.SELECTION_CHANGED);
        }
    }

    @Override
    public synchronized IComplexSignalMeasurement<?>[] getMeasurements() {
        return this.measurements.toArray(new IComplexSignalMeasurement[0]);
    }

    public synchronized void removeMeasurement(IComplexSignalMeasurement<?> measurement) {
        if (this.measurements.remove(measurement)) {
            if (this.measurement == measurement) {
                if (this.measurements.size() > 0) {
                    this.setActiveMeasurement(this.measurements.get(this.measurements.size() - 1));
                } else {
                    this.setActiveMeasurement(null);
                }
            }
            this.setChanged();
            this.notifyObservers((Object)IDataNMRSelection.ChangeType.REMOVED_ITEM);
        }
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
    }

    @Override
    public void removeObserver(Observer observer) {
        this.deleteObserver(observer);
    }

    @Override
    public synchronized void addObserver(Observer o) {
        super.addObserver(o);
    }
}

