/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.ui.internal.provider;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class SampleQuantLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish();

    public Image getColumnImage(Object element, int columnIndex) {
        ISampleQuantSubstance sampleQuantSubstance;
        if (columnIndex == 0) {
            return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/peak.gif", "16x16");
        }
        if (columnIndex == 7) {
            if (element instanceof ISampleQuantSubstance) {
                ISampleQuantSubstance sampleQuantSubstance2 = (ISampleQuantSubstance)element;
                if (sampleQuantSubstance2.getType().equals("ISTD")) {
                    return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/sample-istd.gif", "16x16");
                }
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/sample.gif", "16x16");
            }
        } else if (columnIndex == 10 && element instanceof ISampleQuantSubstance && !(sampleQuantSubstance = (ISampleQuantSubstance)element).getType().equals("ISTD")) {
            if (sampleQuantSubstance.isValidated()) {
                return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/selected.gif", "16x16");
            }
            return ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/deselected.gif", "16x16");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = "";
        if (element instanceof ISampleQuantSubstance) {
            ISampleQuantSubstance sampleQuantSubstance = (ISampleQuantSubstance)element;
            switch (columnIndex) {
                case 0: {
                    text = Integer.toString(sampleQuantSubstance.getId());
                    break;
                }
                case 1: {
                    text = sampleQuantSubstance.getCasNumber();
                    break;
                }
                case 2: {
                    text = sampleQuantSubstance.getName();
                    break;
                }
                case 3: {
                    text = Integer.toString(sampleQuantSubstance.getMaxScan());
                    break;
                }
                case 4: {
                    text = this.decimalFormat.format(sampleQuantSubstance.getConcentration());
                    break;
                }
                case 5: {
                    text = sampleQuantSubstance.getUnit();
                    break;
                }
                case 6: {
                    text = sampleQuantSubstance.getMisc();
                    break;
                }
                case 7: {
                    text = "";
                    break;
                }
                case 8: {
                    if (sampleQuantSubstance.getType().equals("ISTD")) break;
                    text = this.decimalFormat.format(sampleQuantSubstance.getMinMatchQuality());
                    break;
                }
                case 9: {
                    if (sampleQuantSubstance.getType().equals("ISTD")) break;
                    text = this.decimalFormat.format(sampleQuantSubstance.getMatchQuality());
                    break;
                }
                case 10: {
                    text = "";
                    break;
                }
                default: {
                    text = "n.v.";
                }
            }
        }
        return text;
    }
}

