/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.ChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.MassSpectrumFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.PeakFilterSettings;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractIon;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;

public class SubtractCalculator {
    private static final Logger logger = Logger.getLogger(SubtractCalculator.class);
    private static final float NORMALIZATION_BASE = 100.0f;

    public void subtractPeakMassSpectraFromChromatogramSelection(IChromatogramSelectionMSD chromatogramSelection, ChromatogramFilterSettings filterSettings) {
        if (chromatogramSelection == null || chromatogramSelection.getChromatogram() == null || filterSettings == null) {
            return;
        }
        IScanMSD massSpectrum = filterSettings.getSubtractMassSpectrum();
        if (massSpectrum == null) {
            logger.warn((Object)"The mass spectrum must be not null.");
            return;
        }
        boolean useNominalMasses = filterSettings.isUseNominalMasses();
        boolean useNormalize = filterSettings.isUseNormalize();
        Map<Double, Float> subtractMassSpectrumMap = this.getMassSpectrumMap(massSpectrum, useNominalMasses, useNormalize);
        IChromatogram chromatogram = chromatogramSelection.getChromatogram();
        int startScan = chromatogram.getScanNumber(chromatogramSelection.getStartRetentionTime());
        int stopScan = chromatogram.getScanNumber(chromatogramSelection.getStopRetentionTime());
        int scanNumber = startScan;
        while (scanNumber <= stopScan) {
            IScan scan = chromatogram.getScan(scanNumber);
            if (scan instanceof IVendorMassSpectrum) {
                IVendorMassSpectrum targetMassSpectrum = (IVendorMassSpectrum)scan;
                this.adjustIntensityValues((IScanMSD)targetMassSpectrum, subtractMassSpectrumMap, useNominalMasses, useNormalize);
            }
            ++scanNumber;
        }
        chromatogram.getChromatogramIntegrationEntries().clear();
        chromatogram.getBackgroundIntegrationEntries().clear();
    }

    public void subtractPeakMassSpectra(List<IPeakMSD> peaks, PeakFilterSettings peakFilterSettings) {
        if (peaks == null || peaks.size() == 0 || peakFilterSettings == null) {
            return;
        }
        IScanMSD massSpectrum = peakFilterSettings.getSubtractMassSpectrum();
        if (massSpectrum == null) {
            logger.warn((Object)"The mass spectrum must be not null.");
            return;
        }
        boolean useNominalMasses = peakFilterSettings.isUseNominalMasses();
        boolean useNormalize = peakFilterSettings.isNormalize();
        Map<Double, Float> subtractMassSpectrumMap = this.getMassSpectrumMap(massSpectrum, useNominalMasses, useNormalize);
        for (IPeakMSD peak : peaks) {
            IPeakMassSpectrum targetMassSpectrum = peak.getExtractedMassSpectrum();
            this.adjustIntensityValues((IScanMSD)targetMassSpectrum, subtractMassSpectrumMap, useNominalMasses, useNormalize);
            peak.getTargets().clear();
            peak.getIntegrationEntries().clear();
            peak.getQuantitationEntries().clear();
        }
    }

    public void subtractMassSpectrum(IScanMSD massSpectrum, MassSpectrumFilterSettings massSpectrumFilterSettings) {
        ArrayList<IScanMSD> massSpectra = new ArrayList<IScanMSD>();
        massSpectra.add(massSpectrum);
        this.subtractMassSpectra(massSpectra, massSpectrumFilterSettings);
    }

    public void subtractMassSpectra(List<IScanMSD> massSpectra, MassSpectrumFilterSettings massSpectrumFilterSettings) {
        if (massSpectra == null || massSpectra.size() == 0 || massSpectrumFilterSettings == null) {
            return;
        }
        IScanMSD massSpectrum = massSpectrumFilterSettings.getSubtractMassSpectrum();
        if (massSpectrum == null) {
            logger.warn((Object)"The mass spectrum must be not null.");
            return;
        }
        boolean useNominalMasses = massSpectrumFilterSettings.isUseNominalMasses();
        boolean useNormalize = massSpectrumFilterSettings.isNormalize();
        Map<Double, Float> subtractMassSpectrumMap = this.getMassSpectrumMap(massSpectrum, useNominalMasses, useNormalize);
        for (IScanMSD targetMassSpectrum : massSpectra) {
            this.adjustIntensityValues(targetMassSpectrum, subtractMassSpectrumMap, useNominalMasses, useNormalize);
            massSpectrum.getTargets().clear();
        }
    }

    public Map<Double, Float> getMassSpectrumMap(IScanMSD massSpectrum, boolean useNominalMasses, boolean normalize) {
        HashMap<Double, Float> massSpectrumMap = new HashMap<Double, Float>();
        if (massSpectrum != null) {
            try {
                IScanMSD subtractMassSpectrum = massSpectrum.makeDeepCopy();
                if (normalize) {
                    subtractMassSpectrum.normalize(100.0f);
                }
                if (useNominalMasses) {
                    IExtractedIonSignal extractedIonSignal = subtractMassSpectrum.getExtractedIonSignal();
                    int startIon = extractedIonSignal.getStartIon();
                    int stopIon = extractedIonSignal.getStopIon();
                    int ion = startIon;
                    while (ion <= stopIon) {
                        float abundance = extractedIonSignal.getAbundance(ion);
                        if (abundance > 0.0f) {
                            massSpectrumMap.put(Double.valueOf(ion), Float.valueOf(abundance));
                        }
                        ++ion;
                    }
                } else {
                    for (IIon ion : subtractMassSpectrum.getIons()) {
                        massSpectrumMap.put(ion.getIon(), Float.valueOf(ion.getAbundance()));
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrumMap;
    }

    public void adjustIntensityValues(IScanMSD targetMassSpectrum, Map<Double, Float> subtractMassSpectrumMap, boolean useNominalMasses, boolean useNormalize) {
        if (targetMassSpectrum == null || subtractMassSpectrumMap == null) {
            return;
        }
        ArrayList<IIon> ionsToRemove = new ArrayList<IIon>();
        for (IIon ion : targetMassSpectrum.getIons()) {
            double mz = useNominalMasses ? (double)AbstractIon.getIon((double)ion.getIon()) : ion.getIon();
            Float subtractIntensity = subtractMassSpectrumMap.get(mz);
            if (subtractIntensity == null || !(subtractIntensity.floatValue() > 0.0f)) continue;
            try {
                float abundance = ion.getAbundance();
                float abundanceAdjusted = useNormalize ? abundance - subtractIntensity.floatValue() / 100.0f * abundance : abundance - subtractIntensity.floatValue();
                if (abundanceAdjusted <= 0.0f) {
                    ionsToRemove.add(ion);
                    continue;
                }
                ion.setAbundance(abundanceAdjusted);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        for (IIon ion : ionsToRemove) {
            targetMassSpectrum.removeIon(ion);
        }
    }
}

