/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.handlers;

import javax.inject.Named;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RedoOperationHandler
implements EventHandler {
    private static IChromatogramSelectionMSD chromatogramSelection;

    @CanExecute
    boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        if (part != null && chromatogramSelection != null) {
            return ((IChromatogramMSD)chromatogramSelection.getChromatogram()).canRedo();
        }
        return false;
    }

    @Execute
    public void execute(UISynchronize uiSynchronize, final @Named(value="activeShell") Shell shell) {
        if (chromatogramSelection != null) {
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Start Redo Operation");
            uiSynchronize.syncExec(new Runnable(){

                @Override
                public void run() {
                    Cursor cursor = shell.getCursor();
                    try {
                        Cursor cursorNew = DisplayUtils.getDisplay().getSystemCursor(1);
                        shell.setCursor(cursorNew);
                        IChromatogramMSD chromatogram = (IChromatogramMSD)chromatogramSelection.getChromatogram();
                        if (chromatogram != null) {
                            chromatogram.redoOperation((IChromatogramSelection)chromatogramSelection);
                        }
                    }
                    finally {
                        shell.setCursor(cursor);
                    }
                }
            });
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Redo Operation finished");
        }
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("chromatogram/msd/update/chromatogramselection")) {
            chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
        }
    }
}

