/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.internal.support;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ChromatogramImportRunnable
implements IRunnableWithProgress {
    private static final Logger logger = Logger.getLogger(ChromatogramImportRunnable.class);
    private File file;
    private ChromatogramSelectionMSD chromatogramSelection;

    public ChromatogramImportRunnable(File file) {
        this.file = file;
    }

    public ChromatogramSelectionMSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask("Import Chromatogram", -1);
                IProcessingInfo processingInfo = ChromatogramConverterMSD.getInstance().convert(this.file, monitor);
                IChromatogramMSD chromatogram = (IChromatogramMSD)processingInfo.getProcessingResult(IChromatogramMSD.class);
                this.chromatogramSelection = new ChromatogramSelectionMSD(chromatogram);
            }
            catch (Exception e) {
                logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }
}

