/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.swt;

import java.io.File;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ComparisonResult;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.implementation.IdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.notifier.MassSpectrumSelectionUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.LibraryModifySupportUI;
import org.eclipse.chemclipse.msd.swt.ui.components.massspectrum.MassSpectrumListUI;
import org.eclipse.chemclipse.msd.swt.ui.preferences.PreferencePage;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.chemclipse.swt.ui.components.ISearchListener;
import org.eclipse.chemclipse.swt.ui.components.SearchSupportUI;
import org.eclipse.chemclipse.swt.ui.preferences.PreferencePageSWT;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.ux.extension.ui.support.PartSupport;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MassSpectrumLibraryUI
extends Composite {
    private static final Logger logger = Logger.getLogger(MassSpectrumLibraryUI.class);
    private MassSpectrumListUI massSpectrumListUI;
    private IComparisonResult comparisonResult = ComparisonResult.createBestMatchComparisonResult();
    private Composite toolbarInfo;
    private Composite toolbarSearch;
    private Composite toolbarModify;
    private Label labelInfo;
    private SearchSupportUI searchSupportUI;
    private LibraryModifySupportUI libraryModifySupportUI;
    private File massSpectrumFile = null;

    public MassSpectrumLibraryUI(Composite parent, int style) {
        super(parent, style);
        this.createControl();
    }

    public void update(File massSpectrumFile, IMassSpectra massSpectra) {
        this.massSpectrumFile = massSpectrumFile;
        this.libraryModifySupportUI.update(massSpectra);
        this.updateLabel();
    }

    private void createControl() {
        Composite composite = new Composite((Composite)this, 0);
        composite.setBackground(Colors.WHITE);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.createToolbarMain(composite);
        this.toolbarInfo = this.createToolbarInfo(composite);
        this.toolbarSearch = this.createToolbarSearch(composite);
        this.toolbarModify = this.createToolbarModify(composite);
        this.massSpectrumListUI = this.createLibraryTable(composite);
        PartSupport.setCompositeVisibility((Composite)this.toolbarInfo, (boolean)true);
        PartSupport.setCompositeVisibility((Composite)this.toolbarSearch, (boolean)false);
        PartSupport.setCompositeVisibility((Composite)this.toolbarModify, (boolean)false);
        this.massSpectrumListUI.setEditEnabled(false);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Colors.WHITE);
        GridData gridDataStatus = new GridData(768);
        gridDataStatus.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridDataStatus);
        composite.setLayout((Layout)new GridLayout(7, false));
        this.createButtonToggleToolbarInfo(composite);
        this.createButtonToggleToolbarSearch(composite);
        this.createButtonToggleToolbarModify(composite);
        this.createButtonToggleToolbarEdit(composite);
        this.createButtonAddLibraryToSearch(composite);
        this.createButtonRemoveLibraryFromSearch(composite);
        this.createSettingsButton(composite);
    }

    private Button createButtonToggleToolbarInfo(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle info toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)MassSpectrumLibraryUI.this.toolbarInfo);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/info.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarSearch(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle search toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)MassSpectrumLibraryUI.this.toolbarSearch);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/search.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarModify(Composite parent) {
        final Button button = new Button(parent, 8);
        button.setToolTipText("Toggle modify toolbar.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean visible = PartSupport.toggleCompositeVisibility((Composite)MassSpectrumLibraryUI.this.toolbarModify);
                if (visible) {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editActive.gif", "16x16"));
                } else {
                    button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/editDefault.gif", "16x16"));
                }
            }
        });
        return button;
    }

    private Button createButtonToggleToolbarEdit(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Enable/disable to edit the table.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/edit_entry.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean editEnabled = !MassSpectrumLibraryUI.this.massSpectrumListUI.isEditEnabled();
                MassSpectrumLibraryUI.this.massSpectrumListUI.setEditEnabled(editEnabled);
                MassSpectrumLibraryUI.this.updateLabel();
            }
        });
        return button;
    }

    private Button createButtonAddLibraryToSearch(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Add the library to the list of searched databases.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/add.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                eventBroker.post("library/msd/add/dbsearch", (Object)MassSpectrumLibraryUI.this.massSpectrumFile);
                MessageDialog.openConfirm((Shell)DisplayUtils.getShell(), (String)"DB Search", (String)"The library has been added.");
            }
        });
        return button;
    }

    private Button createButtonRemoveLibraryFromSearch(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Remove the library from the list of searched databases.");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/remove.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                eventBroker.post("library/msd/remove/dbsearch", (Object)MassSpectrumLibraryUI.this.massSpectrumFile);
                MessageDialog.openConfirm((Shell)DisplayUtils.getShell(), (String)"DB Search", (String)"The library has been removed.");
            }
        });
        return button;
    }

    private void createSettingsButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setToolTipText("Open the Settings");
        button.setText("");
        button.setImage(ApplicationImageFactory.getInstance().getImage("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageSWT preferencePageSWT = new PreferencePageSWT();
                preferencePageSWT.setTitle("Settings (SWT)");
                PreferencePage preferencePageMSD = new PreferencePage();
                preferencePageMSD.setTitle("Settings (MSD)");
                PreferenceManager preferenceManager = new PreferenceManager();
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)preferencePageSWT));
                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode("2", (IPreferencePage)preferencePageMSD));
                PreferenceDialog preferenceDialog = new PreferenceDialog(DisplayUtils.getShell(), preferenceManager);
                preferenceDialog.create();
                preferenceDialog.setMessage("Settings");
                if (preferenceDialog.open() == 0) {
                    try {
                        MassSpectrumLibraryUI.this.applySettings();
                    }
                    catch (Exception e1) {
                        MessageDialog.openError((Shell)DisplayUtils.getShell(), (String)"Settings", (String)"Something has gone wrong to apply the settings.");
                    }
                }
            }
        });
    }

    private Composite createToolbarInfo(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(Colors.WHITE);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(1, true));
        this.labelInfo = new Label(composite, 0);
        this.labelInfo.setBackground(Colors.WHITE);
        this.labelInfo.setText("");
        this.labelInfo.setLayoutData((Object)new GridData(768));
        return composite;
    }

    private Composite createToolbarSearch(Composite parent) {
        this.searchSupportUI = new SearchSupportUI(parent, 0);
        this.searchSupportUI.setBackground(Colors.WHITE);
        this.searchSupportUI.setLayoutData((Object)new GridData(768));
        this.searchSupportUI.setSearchListener(new ISearchListener(){

            public void performSearch(String searchText, boolean caseSensitive) {
                MassSpectrumLibraryUI.this.massSpectrumListUI.setSearchText(searchText, caseSensitive);
                MassSpectrumLibraryUI.this.updateLabel();
            }
        });
        return this.searchSupportUI;
    }

    private Composite createToolbarModify(Composite parent) {
        this.libraryModifySupportUI = new LibraryModifySupportUI(parent, 0);
        this.libraryModifySupportUI.setBackground(Colors.WHITE);
        this.libraryModifySupportUI.setLayoutData((Object)new GridData(768));
        return this.libraryModifySupportUI;
    }

    private MassSpectrumListUI createLibraryTable(Composite parent) {
        final MassSpectrumListUI massSpectrumListUI = new MassSpectrumListUI(parent, 268438274);
        massSpectrumListUI.getTable().setLayoutData((Object)new GridData(1808));
        massSpectrumListUI.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (firstElement != null && firstElement instanceof IScanMSD) {
                    IScanMSD massSpectrum = (IScanMSD)firstElement;
                    MassSpectrumSelectionUpdateNotifier.fireUpdateChange((IScanMSD)massSpectrum, (boolean)true);
                    IEventBroker eventBroker = ModelSupportAddon.getEventBroker();
                    IIdentificationTarget identificationTarget = MassSpectrumLibraryUI.this.getIdentificationTarget(massSpectrum);
                    eventBroker.send("identification/target/update", (Object)identificationTarget);
                    massSpectrumListUI.getTable().setFocus();
                }
            }
        });
        this.libraryModifySupportUI.setReferencedComposites(massSpectrumListUI, this.searchSupportUI);
        return massSpectrumListUI;
    }

    private IIdentificationTarget getIdentificationTarget(IScanMSD scanMSD) {
        IRegularLibraryMassSpectrum libraryMassSpectrum;
        IdentificationTarget identificationTarget = null;
        ILibraryInformation libraryInformation = null;
        if (scanMSD instanceof IRegularLibraryMassSpectrum && (libraryInformation = (libraryMassSpectrum = (IRegularLibraryMassSpectrum)scanMSD).getLibraryInformation()) != null) {
            try {
                identificationTarget = new IdentificationTarget(libraryInformation, this.comparisonResult);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
        }
        return identificationTarget;
    }

    private void updateLabel() {
        String filterInformation = "[" + this.searchSupportUI.getSearchText() + "]";
        String editInformation = this.massSpectrumListUI.isEditEnabled() ? "Edit is enabled." : "Edit is disabled.";
        this.labelInfo.setText("Mass Spectra: " + this.getItemSize() + " " + filterInformation + " - " + editInformation);
    }

    private int getItemSize() {
        return this.massSpectrumListUI.getTable().getItemCount();
    }

    private void applySettings() {
    }
}

