/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.AbstractFilter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.filters.IFilter;
import org.eclipse.chemclipse.model.statistics.ISample;
import org.eclipse.chemclipse.model.statistics.ISampleData;
import org.eclipse.chemclipse.model.statistics.ISamples;
import org.eclipse.chemclipse.model.statistics.IVariable;

public class EmptyDataFilter
extends AbstractFilter
implements IFilter {
    private String selectionResult = "";

    public EmptyDataFilter() {
        super(IFilter.DataTypeProcessing.MODIFIED_DATA);
    }

    @Override
    public <V extends IVariable, S extends ISample> List<Boolean> filter(ISamples<V, S> samples) {
        List<S> selectedSamples = this.selectSamples(samples);
        ArrayList<Boolean> selection = new ArrayList<Boolean>();
        int i = 0;
        while (i < samples.getVariables().size()) {
            int index = i++;
            boolean b = selectedSamples.stream().map(s -> (ISampleData)s.getSampleData().get(index)).allMatch(d -> !d.isEmpty());
            selection.add(b);
        }
        this.selectionResult = IFilter.getNumberSelectedRow(selection);
        return selection;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getName() {
        return "Empty Data";
    }

    @Override
    public String getSelectionResult() {
        return this.selectionResult;
    }
}

