/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model;

import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.FilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.IPreprocessingSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.core.PreprocessingSettings;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.Algorithm;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.pca.model.IAnalysisSettings;

public class AnalysisSettings
implements IAnalysisSettings {
    private int numberOfPrincipalComponents = 3;
    private Algorithm algorithm = Algorithm.NIPALS;
    private boolean removeUselessVariables = true;
    private IPreprocessingSettings preprocessingSettings = new PreprocessingSettings();
    private IFilterSettings filterSettings = new FilterSettings();

    public AnalysisSettings() {
    }

    public AnalysisSettings(IAnalysisSettings analysisSettings) {
        this.numberOfPrincipalComponents = analysisSettings.getNumberOfPrincipalComponents();
        this.algorithm = analysisSettings.getAlgorithm();
        this.removeUselessVariables = analysisSettings.isRemoveUselessVariables();
        this.preprocessingSettings = new PreprocessingSettings(analysisSettings.getPreprocessingSettings());
        this.filterSettings = new FilterSettings(analysisSettings.getFilterSettings());
    }

    @Override
    public int getNumberOfPrincipalComponents() {
        return this.numberOfPrincipalComponents;
    }

    @Override
    public void setNumberOfPrincipalComponents(int numberOfPrincipalComponents) {
        this.numberOfPrincipalComponents = numberOfPrincipalComponents;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean isRemoveUselessVariables() {
        return this.removeUselessVariables;
    }

    @Override
    public void setRemoveUselessVariables(boolean removeUselessVariables) {
        this.removeUselessVariables = removeUselessVariables;
    }

    @Override
    public IPreprocessingSettings getPreprocessingSettings() {
        return this.preprocessingSettings;
    }

    @Override
    public void setPreprocessingSettings(IPreprocessingSettings preprocessingSettings) {
        this.preprocessingSettings = preprocessingSettings;
    }

    @Override
    public IFilterSettings getFilterSettings() {
        return this.filterSettings;
    }

    @Override
    public void setFilterSettings(IFilterSettings filterSettings) {
        this.filterSettings = filterSettings;
    }
}

