/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.columns.RetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.SeparationColumn;
import org.eclipse.chemclipse.model.columns.SeparationColumnIndices;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public class AMDISConverter {
    private static final Logger logger = Logger.getLogger(AMDISConverter.class);

    public IProcessingInfo parseRetentionIndices(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.setProcessingResult((Object)this.parse(file));
        return processingInfo;
    }

    public ISeparationColumnIndices parse(File file) {
        SeparationColumnIndices separationColumnIndices = new SeparationColumnIndices();
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String name = "DEFAULT";
            String length = "";
            String diameter = "";
            String phase = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("#")) {
                    if (line.startsWith("#COLUMN_NAME")) {
                        name = this.getValue(line);
                        continue;
                    }
                    if (line.startsWith("#COLUMN_LENGTH")) {
                        length = this.getValue(line);
                        continue;
                    }
                    if (line.startsWith("#COLUMN_DIAMETER")) {
                        diameter = this.getValue(line);
                        continue;
                    }
                    if (!line.startsWith("#COLUMN_PHASE")) continue;
                    phase = this.getValue(line);
                    continue;
                }
                try {
                    String[] values = line.split(" ");
                    if (values.length >= 5) {
                        int retentionTime = (int)(Double.parseDouble(values[0]) * 60000.0);
                        float retentionIndex = Float.parseFloat(values[1]);
                        String peakName = values[4].trim();
                        int i = 5;
                        while (i < values.length) {
                            peakName = String.valueOf(peakName) + " " + values[i];
                            ++i;
                        }
                        RetentionIndexEntry retentionIndexEntry = new RetentionIndexEntry(retentionTime, retentionIndex, peakName);
                        separationColumnIndices.put((IRetentionIndexEntry)retentionIndexEntry);
                        continue;
                    }
                    throw new IOException("Unexpected column count: " + Arrays.asList(values).toString());
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)e);
                }
            }
            SeparationColumn separationColumn = new SeparationColumn(name, length, diameter, phase);
            separationColumnIndices.setSeparationColumn((ISeparationColumn)separationColumn);
            bufferedReader.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return separationColumnIndices;
    }

    private String getValue(String line) {
        String value = "";
        String[] values = line.split("=");
        if (values.length == 2) {
            value = values[1].trim();
        }
        return value;
    }
}

