/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.ui.modifier;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.filter.core.chromatogram.ChromatogramFilter;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter.settings.FilterSettingsShift;
import org.eclipse.chemclipse.model.processor.AbstractChromatogramProcessor;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class FilterModifierShift
extends AbstractChromatogramProcessor
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "RTShifter Filter";
    private static final String FILTER_ID = "org.eclipse.chemclipse.chromatogram.xxd.filter.supplier.rtshifter";
    private int millisecondsToShift;

    public FilterModifierShift(IChromatogramSelection chromatogramSelection, int millisecondsToShift) {
        super(chromatogramSelection);
        this.millisecondsToShift = millisecondsToShift;
    }

    public void execute(IProgressMonitor monitor) {
        if (this.getChromatogramSelection() != null) {
            IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
            boolean isShiftAllScans = PreferenceSupplier.getIsShiftAllScans();
            FilterSettingsShift filterSettings = new FilterSettingsShift(this.millisecondsToShift, isShiftAllScans);
            IProcessingInfo processingInfo = ChromatogramFilter.applyFilter((IChromatogramSelection)chromatogramSelection, (IChromatogramFilterSettings)filterSettings, (String)FILTER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            this.getChromatogramSelection().getChromatogram().doOperation((IChromatogramProcessor)this, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

