/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.toolcontrols;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.support.ui.addons.ModelSupportAddon;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ActivePerspective {
    @Inject
    private Composite parent;
    private IEventBroker eventBroker = null;
    private EventHandler eventHandler = null;

    @PostConstruct
    private void initialize() {
        this.parent.setLayout((Layout)new GridLayout(1, true));
        final Label label = new Label(this.parent, 0);
        this.setPerspectiveLabel(label, ModelSupportAddon.getActivePerspective());
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 0x1000000;
        gridData.minimumWidth = 300;
        label.setLayoutData((Object)gridData);
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    String perspectiveName = (String)event.getProperty("org.eclipse.e4.data");
                    ActivePerspective.this.setPerspectiveLabel(label, perspectiveName);
                }
            };
            this.eventBroker.subscribe("application/select/perspective", this.eventHandler);
        }
    }

    private void setPerspectiveLabel(Label label, String perspectiveName) {
        perspectiveName = perspectiveName.replaceAll("<", "");
        perspectiveName = perspectiveName.replaceAll(">", "");
        label.setText("Perspective: " + perspectiveName);
    }

    @PreDestroy
    private void preDestroy() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

