/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.chemclipse.msd.converter.io.AbstractChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.IChromatogramMSDZipReader;

public abstract class AbstractChromatogramReader
extends AbstractChromatogramMSDReader
implements IChromatogramMSDZipReader {
    public DataInputStream getDataInputStream(Object object, String entryName) throws IOException {
        return this.getDataInputStream(object, entryName, false);
    }

    public DataInputStream getDataInputStream(Object object, String entryName, boolean isDirectory) throws IOException {
        if (object instanceof ZipFile) {
            return this.getDataInputStream((ZipFile)object, entryName, isDirectory);
        }
        if (object instanceof ZipInputStream) {
            return this.getDataInputStream((ZipInputStream)object, entryName, isDirectory);
        }
        return null;
    }

    public DataInputStream getDataInputStream(ZipFile zipFile, String entryName) throws IOException {
        return this.getDataInputStream(zipFile, entryName, false);
    }

    public DataInputStream getDataInputStream(ZipFile zipFile, String entryName, boolean isDirectory) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String name = zipEntry.getName();
            if (!(isDirectory && zipEntry.isDirectory() ? name.equals(entryName) : !zipEntry.isDirectory() && name.equals(entryName))) continue;
            return new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    public DataInputStream getDataInputStream(ZipInputStream zipInputStream, String entryName) throws IOException {
        return this.getDataInputStream(zipInputStream, entryName, false);
    }

    public DataInputStream getDataInputStream(ZipInputStream zipInputStream, String entryName, boolean isDirectory) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String name = zipEntry.getName();
            if (!(isDirectory && zipEntry.isDirectory() ? name.equals(entryName) : !zipEntry.isDirectory() && name.equals(entryName))) continue;
            return new DataInputStream(zipInputStream);
        }
        throw new IOException("There could be found no entry given with the name: " + entryName);
    }

    public String readString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= length) {
            builder.append(String.valueOf(dataInputStream.readChar()));
            ++i;
        }
        return builder.toString();
    }
}

