/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.io.AbstractChromatogramWriter;
import org.eclipse.chemclipse.converter.io.IFileHelper;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.io.ChromatogramWriterCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.columns.IRetentionIndexEntry;
import org.eclipse.chemclipse.model.columns.ISeparationColumn;
import org.eclipse.chemclipse.model.columns.ISeparationColumnIndices;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.targets.ITarget;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.ChromatogramWriterMSD;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.io.IChromatogramMSDZipWriter;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IRegularMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.IVendorMassSpectrum;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.io.ChromatogramWriterWSD;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.IScanProxy;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.ScanProxy;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ChromatogramWriter_1301
extends AbstractChromatogramWriter
implements IChromatogramMSDZipWriter {
    public void writeChromatogram(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(PreferenceSupplier.getChromatogramCompressionLevel());
        zipOutputStream.setMethod(8);
        this.writeChromatogram(zipOutputStream, "", chromatogram, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    @Override
    public void writeChromatogram(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        this.writeVersion(zipOutputStream, directoryPrefix, monitor);
        this.writeOverviewFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
        this.writeChromatogramFolder(zipOutputStream, directoryPrefix, chromatogram, monitor);
        List referencedChromatograms = chromatogram.getReferencedChromatograms();
        this.writeChromatogramReferenceInfo(zipOutputStream, directoryPrefix, referencedChromatograms, monitor);
        this.writeReferencedChromatograms(zipOutputStream, directoryPrefix, referencedChromatograms, monitor);
    }

    private void writeVersion(ZipOutputStream zipOutputStream, String directoryPrefix, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        String version = "1.3.0.1";
        dataOutputStream.writeInt(version.length());
        dataOutputStream.writeChars(version);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeOverviewFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/OVERVIEW/");
        zipOutputStream.putNextEntry(zipEntry);
        zipOutputStream.closeEntry();
        zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/OVERVIEW/TIC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        int scan = 1;
        while (scan <= scans) {
            dataOutputStream.writeInt(chromatogram.getScan(scan).getRetentionTime());
            dataOutputStream.writeFloat(chromatogram.getScan(scan).getTotalSignal());
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramFolder(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Chromatogram", (int)100);
        try {
            ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.closeEntry();
            this.writeChromatogramMethod(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramScans(zipOutputStream, directoryPrefix, chromatogram, (IProgressMonitor)subMonitor);
            this.writeChromatogramBaseline(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramPeaks(zipOutputStream, directoryPrefix, chromatogram);
            this.writeChromatogramArea(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramIdentification(zipOutputStream, directoryPrefix, chromatogram);
            this.writeChromatogramHistory(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
            this.writeChromatogramMiscellaneous(zipOutputStream, directoryPrefix, chromatogram);
            this.writeSeparationColumn(zipOutputStream, directoryPrefix, chromatogram);
            subMonitor.worked(20);
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }

    private void writeChromatogramMethod(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/SYSTEM_SETTINGS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IMethod method = chromatogram.getMethod();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)method.getInstrumentName());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)method.getIonSource());
        dataOutputStream.writeDouble(method.getSamplingRate());
        dataOutputStream.writeInt(method.getSolventDelay());
        dataOutputStream.writeDouble(method.getSourceHeater());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)method.getStopMode());
        dataOutputStream.writeInt(method.getStopTime());
        dataOutputStream.writeInt(method.getTimeFilterPeakWidth());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramScans(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        ArrayList<IScanProxy> scanProxies = new ArrayList<IScanProxy>();
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/SCANS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Scans", (int)scans);
        try {
            int scan = 1;
            while (scan <= scans) {
                IVendorMassSpectrum massSpectrum = chromatogram.getSupplierScan(scan);
                int offset = dataOutputStream.size();
                int retentionTime = massSpectrum.getRetentionTime();
                int numberOfIons = massSpectrum.getNumberOfIons();
                float totalSignal = massSpectrum.getTotalSignal();
                float retentionIndex = massSpectrum.getRetentionIndex();
                int timeSegmentId = massSpectrum.getTimeSegmentId();
                int cycleNumber = massSpectrum.getCycleNumber();
                ScanProxy scanProxy = new ScanProxy(offset, retentionTime, numberOfIons, totalSignal, retentionIndex, timeSegmentId, cycleNumber);
                scanProxies.add(scanProxy);
                this.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
                IScanMSD optimizedMassSpectrum = massSpectrum.getOptimizedMassSpectrum();
                if (optimizedMassSpectrum == null) {
                    dataOutputStream.writeBoolean(false);
                } else {
                    dataOutputStream.writeBoolean(true);
                    this.writeNormalMassSpectrum(dataOutputStream, optimizedMassSpectrum);
                }
                subMonitor.worked(1);
                ++scan;
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
        this.writeChromatogramScanProxies(zipOutputStream, directoryPrefix, scanProxies);
    }

    private void writeChromatogramScanProxies(ZipOutputStream zipOutputStream, String directoryPrefix, List<IScanProxy> scanProxies) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/SCANPROXIES");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        dataOutputStream.writeInt(scanProxies.size());
        for (IScanProxy scanProxy : scanProxies) {
            dataOutputStream.writeInt(scanProxy.getOffset());
            dataOutputStream.writeInt(scanProxy.getRetentionTime());
            dataOutputStream.writeInt(scanProxy.getNumberOfIons());
            dataOutputStream.writeFloat(scanProxy.getTotalSignal());
            dataOutputStream.writeFloat(scanProxy.getRetentionIndex());
            dataOutputStream.writeInt(scanProxy.getTimeSegmentId());
            dataOutputStream.writeInt(scanProxy.getCycleNumber());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramBaseline(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/BASELINE");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        int scans = chromatogram.getNumberOfScans();
        dataOutputStream.writeInt(scans);
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int scan = 1;
        while (scan <= scans) {
            int retentionTime = chromatogram.getSupplierScan(scan).getRetentionTime();
            float backgroundAbundance = baselineModel.getBackground(retentionTime);
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(backgroundAbundance);
            ++scan;
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramPeaks(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/PEAKS");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List peaks = chromatogram.getPeaks();
        dataOutputStream.writeInt(peaks.size());
        for (IChromatogramPeakMSD peak : peaks) {
            this.writePeak(dataOutputStream, (IPeakMSD)peak);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramArea(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/AREA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        List chromatogramIntegrationEntries = chromatogram.getChromatogramIntegrationEntries();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, chromatogramIntegrationEntries);
        List backgroundIntegrationEntries = chromatogram.getBackgroundIntegrationEntries();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)chromatogram.getIntegratorDescription());
        this.writeIntegrationEntries(dataOutputStream, backgroundIntegrationEntries);
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramIdentification(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/IDENTIFICATION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        Set chromatogramTargets = chromatogram.getTargets();
        dataOutputStream.writeInt(chromatogramTargets.size());
        for (IIdentificationTarget chromatogramTarget : chromatogramTargets) {
            if (!(chromatogramTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = chromatogramTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramHistory(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/HISTORY");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        IEditHistory editHistory = chromatogram.getEditHistory();
        dataOutputStream.writeInt(editHistory.size());
        for (IEditInformation editInformation : editHistory) {
            dataOutputStream.writeLong(editInformation.getDate().getTime());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)editInformation.getDescription());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramMiscellaneous(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/MISC");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        Map headerData = chromatogram.getHeaderDataMap();
        dataOutputStream.writeInt(headerData.size());
        for (Map.Entry data : headerData.entrySet()) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)((String)data.getKey()));
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)((String)data.getValue()));
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeMassSpectrum(DataOutputStream dataOutputStream, IRegularMassSpectrum massSpectrum) throws IOException {
        dataOutputStream.writeShort(massSpectrum.getMassSpectrometer());
        dataOutputStream.writeShort(massSpectrum.getMassSpectrumType());
        dataOutputStream.writeDouble(massSpectrum.getPrecursorIon());
        this.writeNormalMassSpectrum(dataOutputStream, (IScanMSD)massSpectrum);
    }

    private void writeNormalMassSpectrum(DataOutputStream dataOutputStream, IScanMSD massSpectrum) throws IOException {
        dataOutputStream.writeInt(massSpectrum.getRetentionTime());
        dataOutputStream.writeInt(massSpectrum.getRelativeRetentionTime());
        dataOutputStream.writeInt(massSpectrum.getRetentionTimeColumn1());
        dataOutputStream.writeInt(massSpectrum.getRetentionTimeColumn2());
        dataOutputStream.writeFloat(massSpectrum.getRetentionIndex());
        dataOutputStream.writeBoolean(massSpectrum.hasAdditionalRetentionIndices());
        if (massSpectrum.hasAdditionalRetentionIndices()) {
            Map retentionIndicesTyped = massSpectrum.getRetentionIndicesTyped();
            dataOutputStream.writeInt(retentionIndicesTyped.size());
            for (Map.Entry retentionIndexTyped : retentionIndicesTyped.entrySet()) {
                IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)((RetentionIndexType)retentionIndexTyped.getKey()).toString());
                dataOutputStream.writeFloat(((Float)retentionIndexTyped.getValue()).floatValue());
            }
        }
        dataOutputStream.writeInt(massSpectrum.getTimeSegmentId());
        dataOutputStream.writeInt(massSpectrum.getCycleNumber());
        List ions = massSpectrum.getIons();
        this.writeMassSpectrumIons(dataOutputStream, ions);
        dataOutputStream.writeInt(massSpectrum.getTargets().size());
        for (ITarget target : massSpectrum.getTargets()) {
            if (!(target instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = (IIdentificationTarget)target;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
    }

    private void writeMassSpectrumIons(DataOutputStream dataOutputStream, List<IIon> ions) throws IOException {
        dataOutputStream.writeInt(ions.size());
        for (IIon ion : ions) {
            dataOutputStream.writeDouble(ion.getIon());
            dataOutputStream.writeFloat(ion.getAbundance());
            IIonTransition ionTransition = ion.getIonTransition();
            if (ionTransition == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(1);
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)ionTransition.getCompoundName());
            dataOutputStream.writeDouble(ionTransition.getQ1StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ1StopIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StartIon());
            dataOutputStream.writeDouble(ionTransition.getQ3StopIon());
            dataOutputStream.writeDouble(ionTransition.getCollisionEnergy());
            dataOutputStream.writeDouble(ionTransition.getQ1Resolution());
            dataOutputStream.writeDouble(ionTransition.getQ3Resolution());
            dataOutputStream.writeInt(ionTransition.getTransitionGroup());
            dataOutputStream.writeInt(ionTransition.getDwell());
        }
    }

    private void writePeak(DataOutputStream dataOutputStream, IPeakMSD peak) throws IOException {
        IPeakModelMSD peakModel = peak.getPeakModel();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getDetectorDescription());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getQuantifierDescription());
        dataOutputStream.writeBoolean(peak.isActiveForAnalysis());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getIntegratorDescription());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getModelDescription());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getPeakType().toString());
        dataOutputStream.writeInt(peak.getSuggestedNumberOfComponents());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)peak.getName());
        IFileHelper.writeStringCollection((DataOutputStream)dataOutputStream, (Collection)peak.getClassifier());
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStartRetentionTime()));
        dataOutputStream.writeFloat(peakModel.getBackgroundAbundance(peakModel.getStopRetentionTime()));
        IPeakMassSpectrum massSpectrum = peakModel.getPeakMassSpectrum();
        this.writeMassSpectrum(dataOutputStream, (IRegularMassSpectrum)massSpectrum);
        List retentionTimes = peakModel.getRetentionTimes();
        dataOutputStream.writeInt(retentionTimes.size());
        Iterator iterator = retentionTimes.iterator();
        while (iterator.hasNext()) {
            int retentionTime = (Integer)iterator.next();
            dataOutputStream.writeInt(retentionTime);
            dataOutputStream.writeFloat(peakModel.getPeakAbundance(retentionTime));
        }
        List integrationEntries = peak.getIntegrationEntries();
        this.writeIntegrationEntries(dataOutputStream, integrationEntries);
        Set peakTargets = peak.getTargets();
        dataOutputStream.writeInt(peakTargets.size());
        for (IIdentificationTarget peakTarget : peakTargets) {
            if (!(peakTarget instanceof IIdentificationTarget)) continue;
            IIdentificationTarget identificationEntry = peakTarget;
            this.writeIdentificationEntry(dataOutputStream, identificationEntry);
        }
        List quantitationEntries = peak.getQuantitationEntries();
        dataOutputStream.writeInt(quantitationEntries.size());
        for (IQuantitationEntry quantitationEntry : quantitationEntries) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getName());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getChemicalClass());
            dataOutputStream.writeDouble(quantitationEntry.getConcentration());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getConcentrationUnit());
            dataOutputStream.writeDouble(quantitationEntry.getArea());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getCalibrationMethod());
            dataOutputStream.writeBoolean(quantitationEntry.getUsedCrossZero());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)quantitationEntry.getDescription());
            if (quantitationEntry.getSignal() != 0.0) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeDouble(quantitationEntry.getSignal());
                continue;
            }
            dataOutputStream.writeBoolean(false);
        }
        IScanMSD optimizedMassSpectrum = massSpectrum.getOptimizedMassSpectrum();
        if (optimizedMassSpectrum == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            this.writeNormalMassSpectrum(dataOutputStream, optimizedMassSpectrum);
        }
        this.writeIntenalStandards(dataOutputStream, peak.getInternalStandards());
    }

    private void writeIntegrationEntries(DataOutputStream dataOutputStream, List<? extends IIntegrationEntry> integrationEntries) throws IOException {
        dataOutputStream.writeInt(integrationEntries.size());
        for (IIntegrationEntry iIntegrationEntry : integrationEntries) {
            dataOutputStream.writeDouble(iIntegrationEntry.getSignal());
            dataOutputStream.writeDouble(iIntegrationEntry.getIntegratedArea());
        }
    }

    private void writeIntenalStandards(DataOutputStream dataOutputStream, List<IInternalStandard> internalStandards) throws IOException {
        dataOutputStream.writeInt(internalStandards.size());
        for (IInternalStandard internalStandard : internalStandards) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)internalStandard.getName());
            dataOutputStream.writeDouble(internalStandard.getConcentration());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)internalStandard.getConcentrationUnit());
            dataOutputStream.writeDouble(internalStandard.getResponseFactor());
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)internalStandard.getChemicalClass());
        }
    }

    private void writeIdentificationEntry(DataOutputStream dataOutputStream, IIdentificationTarget identificationEntry) throws IOException {
        ILibraryInformation libraryInformation = identificationEntry.getLibraryInformation();
        IComparisonResult comparisonResult = identificationEntry.getComparisonResult();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)identificationEntry.getIdentifier());
        dataOutputStream.writeBoolean(identificationEntry.isManuallyVerified());
        dataOutputStream.writeInt(libraryInformation.getRetentionTime());
        dataOutputStream.writeFloat(libraryInformation.getRetentionIndex());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getCasNumber());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getComments());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getReferenceIdentifier());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getMiscellaneous());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getDatabase());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getContributor());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getName());
        Set synonyms = libraryInformation.getSynonyms();
        int numberOfSynonyms = synonyms.size();
        dataOutputStream.writeInt(numberOfSynonyms);
        for (String synonym : synonyms) {
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)synonym);
        }
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getFormula());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getSmiles());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)libraryInformation.getInChI());
        dataOutputStream.writeDouble(libraryInformation.getMolWeight());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactor());
        dataOutputStream.writeFloat(comparisonResult.getReverseMatchFactorDirect());
        dataOutputStream.writeFloat(comparisonResult.getProbability());
        dataOutputStream.writeBoolean(comparisonResult.isMatch());
    }

    private void writeSeparationColumn(ZipOutputStream zipOutputStream, String directoryPrefix, IChromatogramMSD chromatogram) throws IOException {
        ZipEntry zipEntry = new ZipEntry(String.valueOf(directoryPrefix) + "MSD/CHROMATOGRAM/SEPARATION_COLUMN");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        ISeparationColumnIndices separationColumnIndices = chromatogram.getSeparationColumnIndices();
        dataOutputStream.writeInt(separationColumnIndices.size());
        for (Map.Entry entry : separationColumnIndices.entrySet()) {
            IRetentionIndexEntry retentionIndexEntry = (IRetentionIndexEntry)entry.getValue();
            IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)retentionIndexEntry.getName());
            dataOutputStream.writeInt(retentionIndexEntry.getRetentionTime());
            dataOutputStream.writeFloat(retentionIndexEntry.getRetentionIndex());
        }
        ISeparationColumn separationColumn = separationColumnIndices.getSeparationColumn();
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getName());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getLength());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getDiameter());
        IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)separationColumn.getPhase());
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeChromatogramReferenceInfo(ZipOutputStream zipOutputStream, String directoryPrefix, List<IChromatogram<?>> referencedChromatograms, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntryType = new ZipEntry(String.valueOf(directoryPrefix) + "REFERENCE_INFO");
        zipOutputStream.putNextEntry(zipEntryType);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        dataOutputStream.writeInt(referencedChromatograms.size());
        zipOutputStream.closeEntry();
    }

    private void writeReferencedChromatograms(ZipOutputStream zipOutputStream, String directoryPrefix, List<IChromatogram<?>> referencedChromatograms, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Write Chromatogram", (int)(referencedChromatograms.size() * 20));
        try {
            ChromatogramWriterMSD chromatogramWriterMSD = new ChromatogramWriterMSD();
            ChromatogramWriterCSD chromatogramWriterCSD = new ChromatogramWriterCSD();
            ChromatogramWriterWSD chromatogramWriterWSD = new ChromatogramWriterWSD();
            int i = 0;
            for (IChromatogram<?> referencedChromatogram : referencedChromatograms) {
                ZipEntry zipEntryChromtogram;
                String prefix = String.valueOf(directoryPrefix) + "CHROMATOGRAM_REFERENCE" + "_" + i++ + "/";
                ZipEntry zipEntryType = new ZipEntry(String.valueOf(prefix) + "CHROMATOGRAM_TYPE");
                zipOutputStream.putNextEntry(zipEntryType);
                DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
                if (referencedChromatogram instanceof IChromatogramMSD) {
                    IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)"MSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterMSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramMSD)referencedChromatogram, monitor);
                } else if (referencedChromatogram instanceof IChromatogramCSD) {
                    IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)"CSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterCSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramCSD)referencedChromatogram, monitor);
                } else if (referencedChromatogram instanceof IChromatogramWSD) {
                    IFileHelper.writeString((DataOutputStream)dataOutputStream, (String)"WSD");
                    dataOutputStream.flush();
                    prefix = String.valueOf(prefix) + "CHROMATOGRAM_REFERENCE/";
                    zipEntryChromtogram = new ZipEntry(prefix);
                    zipOutputStream.putNextEntry(zipEntryChromtogram);
                    chromatogramWriterWSD.writeChromatogram(zipOutputStream, prefix, (IChromatogramWSD)referencedChromatogram, monitor);
                }
                subMonitor.worked(20);
                zipOutputStream.closeEntry();
            }
        }
        finally {
            SubMonitor.done((IProgressMonitor)subMonitor);
        }
    }
}

